/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearches;
import org.apache.james.mailbox.store.search.SearchUtil;

public class SimpleMessageSearchIndex
implements MessageSearchIndex {
    private final MessageMapperFactory messageMapperFactory;
    private final MailboxMapperFactory mailboxMapperFactory;
    private final TextExtractor textExtractor;

    @Inject
    public SimpleMessageSearchIndex(MessageMapperFactory messageMapperFactory, MailboxMapperFactory mailboxMapperFactory, TextExtractor textExtractor) {
        this.messageMapperFactory = messageMapperFactory;
        this.mailboxMapperFactory = mailboxMapperFactory;
        this.textExtractor = textExtractor;
    }

    @Override
    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.PartialEmailMatch, MailboxManager.SearchCapabilities.AttachmentFileName);
    }

    private static SearchQuery.UidCriterion findConjugatedUidCriterion(List<SearchQuery.Criterion> crits) {
        for (SearchQuery.Criterion crit : crits) {
            if (crit instanceof SearchQuery.UidCriterion) {
                return (SearchQuery.UidCriterion)crit;
            }
            if (!(crit instanceof SearchQuery.ConjunctionCriterion)) continue;
            return SimpleMessageSearchIndex.findConjugatedUidCriterion(((SearchQuery.ConjunctionCriterion)crit).getCriteria());
        }
        return null;
    }

    @Override
    public Stream<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery query) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return this.searchResults(session, ImmutableList.of((Object)mailbox).stream(), query).stream().filter(searchResult -> searchResult.getMailboxId().equals(mailbox.getMailboxId())).map(MessageSearchIndex.SearchResult::getMessageUid);
    }

    private List<MessageSearchIndex.SearchResult> searchResults(MailboxSession session, Mailbox mailbox, SearchQuery query) throws MailboxException {
        MessageMapper mapper = this.messageMapperFactory.getMessageMapper(session);
        TreeSet<MailboxMessage> hitSet = new TreeSet<MailboxMessage>();
        SearchQuery.UidCriterion uidCrit = SimpleMessageSearchIndex.findConjugatedUidCriterion(query.getCriterias());
        if (uidCrit != null) {
            SearchQuery.UidRange[] ranges;
            for (SearchQuery.UidRange r : ranges = uidCrit.getOperator().getRange()) {
                Iterator<MailboxMessage> it = mapper.findInMailbox(mailbox, MessageRange.range((MessageUid)r.getLowValue(), (MessageUid)r.getHighValue()), MessageMapper.FetchType.Metadata, -1);
                while (it.hasNext()) {
                    hitSet.add(it.next());
                }
            }
        } else {
            Iterator<MailboxMessage> messages = mapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, -1);
            while (messages.hasNext()) {
                MailboxMessage m = messages.next();
                hitSet.add(m);
            }
        }
        return ImmutableList.copyOf(new MessageSearches(hitSet.iterator(), query, this.textExtractor).iterator());
    }

    @Override
    public List<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) throws MailboxException {
        MailboxMapper mailboxManager = this.mailboxMapperFactory.getMailboxMapper(session);
        Stream<Mailbox> filteredMailboxes = mailboxIds.stream().map(Throwing.function(mailboxManager::findMailboxById).sneakyThrow());
        return this.getAsMessageIds(this.searchResults(session, filteredMailboxes, searchQuery), limit);
    }

    private List<MessageSearchIndex.SearchResult> searchResults(MailboxSession session, Stream<Mailbox> mailboxes, SearchQuery query) throws MailboxException {
        return (List)mailboxes.flatMap(mailbox -> this.getSearchResultStream(session, query, (Mailbox)mailbox)).collect(Guavate.toImmutableList());
    }

    private Stream<? extends MessageSearchIndex.SearchResult> getSearchResultStream(MailboxSession session, SearchQuery query, Mailbox mailbox) {
        try {
            return this.searchResults(session, mailbox, query).stream();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private List<MessageId> getAsMessageIds(List<MessageSearchIndex.SearchResult> temp, long limit) {
        return (List)temp.stream().map(searchResult -> searchResult.getMessageId().get()).filter(SearchUtil.distinct()).limit(Long.valueOf(limit).intValue()).collect(Guavate.toImmutableList());
    }
}

