/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.Map;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;

public class StoreQuotaManager
implements QuotaManager {
    private final CurrentQuotaManager currentQuotaManager;
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public StoreQuotaManager(CurrentQuotaManager currentQuotaManager, MaxQuotaManager maxQuotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.maxQuotaManager = maxQuotaManager;
    }

    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageQuota(QuotaRoot quotaRoot) throws MailboxException {
        Map maxMessageDetails = this.maxQuotaManager.listMaxMessagesDetails(quotaRoot);
        return Quota.builder().used((QuotaUsageValue)this.currentQuotaManager.getCurrentMessageCount(quotaRoot)).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxMessage(maxMessageDetails).orElse(QuotaCountLimit.unlimited())).limitsByScope(maxMessageDetails).build();
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot quotaRoot) throws MailboxException {
        Map maxStorageDetails = this.maxQuotaManager.listMaxStorageDetails(quotaRoot);
        return Quota.builder().used((QuotaUsageValue)this.currentQuotaManager.getCurrentStorage(quotaRoot)).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxStorage(maxStorageDetails).orElse(QuotaSizeLimit.unlimited())).limitsByScope(maxStorageDetails).build();
    }
}

