/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class QuotaChecker {
    private final Quota<QuotaCountLimit, QuotaCountUsage> messageQuota;
    private final Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
    private final QuotaRoot quotaRoot;

    public QuotaChecker(QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, Mailbox mailbox) throws MailboxException {
        this.quotaRoot = quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
        this.messageQuota = quotaManager.getMessageQuota(this.quotaRoot);
        this.sizeQuota = quotaManager.getStorageQuota(this.quotaRoot);
    }

    public QuotaChecker(Quota<QuotaCountLimit, QuotaCountUsage> messageQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, QuotaRoot quotaRoot) {
        this.messageQuota = messageQuota;
        this.sizeQuota = sizeQuota;
        this.quotaRoot = quotaRoot;
    }

    public void tryAddition(long count, long size) throws OverQuotaException {
        this.tryCountAddition(count);
        this.trySizeAddition(size);
    }

    private void trySizeAddition(long size) throws OverQuotaException {
        Quota afterAdditionQuotaSize = this.sizeQuota.addValueToQuota((QuotaUsageValue)QuotaSizeUsage.size((long)size));
        if (afterAdditionQuotaSize.isOverQuota()) {
            throw new OverQuotaException("You use too much space in " + this.quotaRoot.getValue(), afterAdditionQuotaSize.getLimit(), afterAdditionQuotaSize.getUsed());
        }
    }

    private void tryCountAddition(long count) throws OverQuotaException {
        Quota afterAdditionQuotaCount = this.messageQuota.addValueToQuota((QuotaUsageValue)QuotaCountUsage.count((long)count));
        if (afterAdditionQuotaCount.isOverQuota()) {
            throw new OverQuotaException("You have too many messages in " + this.quotaRoot.getValue(), this.messageQuota.getLimit(), this.messageQuota.getUsed());
        }
    }
}

