/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.util.streams.Iterators;

public class ApplicableFlagCalculator {
    private final Iterable<MailboxMessage> mailboxMessages;

    public ApplicableFlagCalculator(Iterable<MailboxMessage> mailboxMessages) {
        Preconditions.checkNotNull(mailboxMessages);
        this.mailboxMessages = mailboxMessages;
    }

    public Flags computeApplicableFlags() {
        return ApplicableFlagBuilder.builder().add((List)Iterators.toStream(this.mailboxMessages.iterator()).map(MailboxMessage::createFlags).collect(Guavate.toImmutableList())).build();
    }
}

