/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.github.steveash.guavate.Guavate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.james.mailbox.store.mail.model.Property;

public class PropertyBuilder {
    private static final int INITIAL_CAPACITY = 32;
    public static final String JAMES_INTERNALS = "JAMES_INTERNALS";
    public static final String HAS_ATTACHMENT = "HAS_ATTACHMENT";
    private Long textualLineCount = null;
    private final List<Property> properties;

    public static Predicate<Property> isHasAttachmentProperty() {
        return property -> property.getNamespace().equals(JAMES_INTERNALS) && property.getLocalName().equals(HAS_ATTACHMENT) && property.getValue().equals("true");
    }

    public PropertyBuilder(List<Property> props) {
        this.properties = new ArrayList<Property>(props.size());
        for (Property property : props) {
            this.properties.add(new Property(property));
        }
    }

    public PropertyBuilder() {
        this.properties = new ArrayList<Property>(32);
    }

    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    public void setTextualLineCount(Long textualLineCount) {
        this.textualLineCount = textualLineCount;
    }

    public String getFirstValue(String namespace, String localName) {
        return this.properties.stream().filter(property -> property.isNamed(namespace, localName)).findFirst().map(Property::getValue).orElse(null);
    }

    public List<String> getValues(String namespace, String localName) {
        return (List)this.properties.stream().filter(property -> property.isNamed(namespace, localName)).map(Property::getValue).collect(Guavate.toImmutableList());
    }

    public void setProperty(String namespace, String localName, String value) {
        this.properties.removeIf(property -> property.isNamed(namespace, localName));
        if (value != null) {
            this.properties.add(new Property(namespace, localName, value));
        }
    }

    public void setProperty(String namespace, String localName, List<String> values) {
        this.properties.removeIf(property -> property.isNamed(namespace, localName));
        if (values != null) {
            for (String value : values) {
                this.properties.add(new Property(namespace, localName, value));
            }
        }
    }

    public SortedMap<String, String> getProperties(String namespace) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        for (Property property : this.properties) {
            if (!property.isInSpace(namespace)) continue;
            parameters.put(property.getLocalName(), property.getValue());
        }
        return parameters;
    }

    public void setProperties(String namespace, Map<String, String> valuesByLocalName) {
        this.properties.removeIf(property -> property.isInSpace(namespace));
        for (Map.Entry<String, String> valueByLocalName : valuesByLocalName.entrySet()) {
            this.properties.add(new Property(namespace, valueByLocalName.getKey().toLowerCase(Locale.US), valueByLocalName.getValue()));
        }
    }

    public String getMediaType() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type", "type");
    }

    public void setMediaType(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type", "type", value);
    }

    public void setHasAttachment(boolean value) {
        this.setProperty(JAMES_INTERNALS, HAS_ATTACHMENT, Boolean.toString(value));
    }

    public String getSubType() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type", "subtype");
    }

    public void setSubType(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type", "subtype", value);
    }

    public String getContentID() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-ID");
    }

    public void setContentID(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-ID", value);
    }

    public String getContentDescription() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-Description");
    }

    public void setContentDescription(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-Description", value);
    }

    public String getContentTransferEncoding() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-Transfer-Encoding");
    }

    public void setContentTransferEncoding(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-Transfer-Encoding", value);
    }

    public String getContentLocation() {
        return this.getFirstValue("http://james.apache.org/rfc2557", "Content-Location");
    }

    public void setContentLocation(String value) {
        this.setProperty("http://james.apache.org/rfc2557", "Content-Location", value);
    }

    public void setContentDispositionType(String value) {
        this.setProperty("http://james.apache.org/rfc2183Content-Disposition", "disposition-type", value);
    }

    public String getContentDispositionType() {
        return this.getFirstValue("http://james.apache.org/rfc2183Content-Disposition", "disposition-type");
    }

    public Map<String, String> getContentDispositionParameters() {
        return this.getProperties("http://james.apache.org/rfc2183Content-Disposition/params");
    }

    public void setContentDispositionParameters(Map<String, String> valuesByParameterName) {
        this.setProperties("http://james.apache.org/rfc2183Content-Disposition/params", valuesByParameterName);
    }

    public Map<String, String> getContentTypeParameters() {
        return this.getProperties("http://james.apache.org/rfc2045/Content-Type/params");
    }

    public void setContentTypeParameters(Map<String, String> valuesByParameterName) {
        this.setProperties("http://james.apache.org/rfc2045/Content-Type/params", valuesByParameterName);
    }

    public String getContentMD5() {
        return this.getFirstValue("http://james.apache.org/rfc1864", "Content-MD5");
    }

    public void setContentMD5(String value) {
        this.setProperty("http://james.apache.org/rfc1864", "Content-MD5", value);
    }

    public String getCharset() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type/params", "charset");
    }

    public void setCharset(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type/params", "charset", value);
    }

    public String getBoundary() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type/params", "boundary");
    }

    public void setBoundary(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type/params", "boundary", value);
    }

    public List<String> getContentLanguage() {
        return this.getValues("http://james.apache.org/rfc1766", "Content-Language");
    }

    public void setContentLanguage(List<String> values) {
        this.setProperty("http://james.apache.org/rfc1766", "Content-Language", values);
    }

    public List<Property> toProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public String toString() {
        return "PropertyBuilder (  textualLineCount = " + this.textualLineCount + " properties = " + this.properties + " )";
    }
}

