/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.mailbox.store.mail.model.FlagsFilter;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class FlagsFactory {
    private static Flags asFlags(MailboxMessage mailboxMessage, String[] userFlags) {
        Flags flags = new Flags();
        if (mailboxMessage.isAnswered()) {
            flags.add(Flags.Flag.ANSWERED);
        }
        if (mailboxMessage.isDeleted()) {
            flags.add(Flags.Flag.DELETED);
        }
        if (mailboxMessage.isDraft()) {
            flags.add(Flags.Flag.DRAFT);
        }
        if (mailboxMessage.isFlagged()) {
            flags.add(Flags.Flag.FLAGGED);
        }
        if (mailboxMessage.isRecent()) {
            flags.add(Flags.Flag.RECENT);
        }
        if (mailboxMessage.isSeen()) {
            flags.add(Flags.Flag.SEEN);
        }
        if (userFlags != null && userFlags.length > 0) {
            for (String userFlag : userFlags) {
                flags.add(userFlag);
            }
        }
        return flags;
    }

    public static Flags createFlags(MailboxMessage mailboxMessage, String[] userFlags) {
        return FlagsFactory.builder().flags(FlagsFactory.asFlags(mailboxMessage, userFlags)).addUserFlags(userFlags).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Flags empty() {
        return FlagsFactory.builder().build();
    }

    public static class Builder {
        private final ArrayList<String> userFlags;
        private Optional<Flags> flags;
        private Optional<FlagsFilter> flagsFilter = Optional.empty();

        private Builder() {
            this.userFlags = new ArrayList();
            this.flags = Optional.empty();
        }

        public Builder flags(Flags flags) {
            this.flags = Optional.of(flags);
            return this;
        }

        public Builder filteringFlags(FlagsFilter filter) {
            this.flagsFilter = Optional.of(filter);
            return this;
        }

        public Builder addUserFlags(String ... userFlags) {
            this.userFlags.addAll(Optional.ofNullable(userFlags).map(Arrays::asList).orElse((List)ImmutableList.of()));
            return this;
        }

        public Flags build() {
            FlagsFilter flagsFilter = this.flagsFilter.orElse(FlagsFilter.noFilter());
            Flags flagsOrEmpty = this.flags.orElse(new Flags());
            Stream<Flags.Flag> flagStream = this.toFlagStream(flagsOrEmpty).filter(flagsFilter.getSystemFlagFilter());
            Stream<String> userFlagsStream = Stream.concat(this.toUserFlagStream(flagsOrEmpty), this.userFlags.stream()).distinct().filter(s -> !Strings.isNullOrEmpty((String)s)).filter(flagsFilter.getUserFlagFilter());
            Flags result = new Flags();
            flagStream.forEach(arg_0 -> ((Flags)result).add(arg_0));
            userFlagsStream.forEach(arg_0 -> ((Flags)result).add(arg_0));
            return result;
        }

        private Stream<Flags.Flag> toFlagStream(Flags flags) {
            return Arrays.stream(flags.getSystemFlags());
        }

        private Stream<String> toUserFlagStream(Flags flags) {
            return Arrays.stream(flags.getUserFlags());
        }
    }
}

