/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.transaction.Mapper;
import reactor.core.publisher.Mono;

public interface MailboxMapper
extends Mapper {
    public Mailbox create(MailboxPath var1, UidValidity var2) throws MailboxException;

    public MailboxId rename(Mailbox var1) throws MailboxException;

    public void delete(Mailbox var1) throws MailboxException;

    public Mono<Mailbox> findMailboxByPath(MailboxPath var1);

    default public Mailbox findMailboxByPathBlocking(MailboxPath mailboxPath) throws MailboxException, MailboxNotFoundException {
        try {
            return (Mailbox)this.findMailboxByPath(mailboxPath).blockOptional().orElseThrow(() -> new MailboxNotFoundException(mailboxPath));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof MailboxException) {
                throw (MailboxException)cause;
            }
            throw e;
        }
    }

    public Mailbox findMailboxById(MailboxId var1) throws MailboxException, MailboxNotFoundException;

    public List<Mailbox> findNonPersonalMailboxes(Username var1, MailboxACL.Right var2) throws MailboxException;

    public List<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound var1) throws MailboxException;

    public boolean hasChildren(Mailbox var1, char var2) throws MailboxException, MailboxNotFoundException;

    public ACLDiff updateACL(Mailbox var1, MailboxACL.ACLCommand var2) throws MailboxException;

    public ACLDiff setACL(Mailbox var1, MailboxACL var2) throws MailboxException;

    public List<Mailbox> list() throws MailboxException;
}

