/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.annotations.VisibleForTesting;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;

public class SystemMailboxesProviderImpl
implements SystemMailboxesProvider {
    private final MailboxManager mailboxManager;

    @Inject
    @VisibleForTesting
    public SystemMailboxesProviderImpl(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public Stream<MessageManager> getMailboxByRole(Role aRole, Username username) throws MailboxException {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)aRole.getDefaultMailbox());
        try {
            return Stream.of(this.mailboxManager.getMailbox(mailboxPath, session));
        }
        catch (MailboxNotFoundException e) {
            return this.searchMessageManagerByMailboxRole(aRole, username);
        }
    }

    private boolean hasRole(Role aRole, MailboxPath mailBoxPath) {
        return Role.from((String)mailBoxPath.getName()).map(arg_0 -> ((Role)aRole).equals(arg_0)).orElse(false);
    }

    private Stream<MessageManager> searchMessageManagerByMailboxRole(Role aRole, Username username) throws MailboxException {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        ThrowingFunction loadMailbox = path -> this.mailboxManager.getMailbox(path, session);
        MailboxQuery mailboxQuery = MailboxQuery.privateMailboxesBuilder((MailboxSession)session).expression((MailboxNameExpression)new PrefixedWildcard(aRole.getDefaultMailbox())).build();
        return this.mailboxManager.search(mailboxQuery, session).stream().map(MailboxMetaData::getPath).filter(path -> this.hasRole(aRole, (MailboxPath)path)).map(Throwing.function((ThrowingFunction)loadMailbox).sneakyThrow());
    }
}

