/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.FetchGroupConverter;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageResultIterator
implements MessageResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMessageResultIterator.class);
    private Iterator<MailboxMessage> next = null;
    private MailboxException exception;
    private final Mailbox mailbox;
    private final FetchGroup group;
    private final MessageUid from;
    private MessageUid cursor;
    private final MessageUid to;
    private final BatchSizes batchSizes;
    private final MessageRange.Type type;
    private final MessageMapper mapper;
    private final MessageMapper.FetchType ftype;

    public StoreMessageResultIterator(MessageMapper mapper, Mailbox mailbox, MessageRange range, BatchSizes batchSizes, FetchGroup group) {
        this.mailbox = mailbox;
        this.group = group;
        this.mapper = mapper;
        this.cursor = this.from = range.getUidFrom();
        this.to = range.getUidTo();
        this.batchSizes = batchSizes;
        this.type = range.getType();
        this.ftype = FetchGroupConverter.getFetchType(group);
        LOGGER.debug("batchSizes used: {}", (Object)batchSizes);
    }

    public boolean hasNext() {
        if (this.cursor.compareTo(this.to) > 0) {
            return false;
        }
        if (this.next == null || !this.next.hasNext()) {
            try {
                this.readBatch();
            }
            catch (MailboxException e) {
                this.exception = e;
                return false;
            }
        }
        return this.next.hasNext();
    }

    private void readBatch() throws MailboxException {
        MessageRange range;
        switch (this.type) {
            default: {
                range = MessageRange.from((MessageUid)this.cursor);
                break;
            }
            case FROM: {
                range = MessageRange.from((MessageUid)this.cursor);
                break;
            }
            case ONE: {
                range = MessageRange.one((MessageUid)this.cursor);
                break;
            }
            case RANGE: {
                range = MessageRange.range((MessageUid)this.cursor, (MessageUid)this.to);
            }
        }
        this.next = this.mapper.findInMailbox(this.mailbox, range, this.ftype, this.batchSizeFromFetchType(this.ftype));
    }

    private int batchSizeFromFetchType(MessageMapper.FetchType fetchType) {
        switch (fetchType) {
            case Metadata: {
                return this.batchSizes.getFetchMetadata();
            }
            case Headers: {
                return this.batchSizes.getFetchHeaders();
            }
            case Body: {
                return this.batchSizes.getFetchBody();
            }
            case Full: {
                return this.batchSizes.getFetchFull();
            }
        }
        throw new RuntimeException("Unknown fetchTpe: " + (Object)((Object)fetchType));
    }

    public MessageResult next() {
        MessageResult result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MailboxMessage message = this.next.next();
        try {
            result = ResultUtils.loadMessageResult(message, this.group);
            this.cursor = result.getUid();
        }
        catch (MailboxException e) {
            result = new UnloadedMessageResult(message, e);
        }
        this.cursor = this.cursor.next();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Read only");
    }

    public MailboxException getException() {
        return this.exception;
    }

    private static final class UnloadedMessageResult
    implements MessageResult {
        private final MailboxException exception;
        private final MessageMetaData messageMetaData;
        private final MessageId messageId;
        private final MailboxId mailboxId;

        public UnloadedMessageResult(MailboxMessage message, MailboxException exception) {
            this.messageMetaData = message.metaData();
            this.mailboxId = message.getMailboxId();
            this.messageId = message.getMessageId();
            this.exception = exception;
        }

        public MessageMetaData messageMetaData() {
            return this.messageMetaData;
        }

        public MessageUid getUid() {
            return this.messageMetaData().getUid();
        }

        public MessageId getMessageId() {
            return this.messageMetaData().getMessageId();
        }

        public Date getInternalDate() {
            return this.messageMetaData().getInternalDate();
        }

        public Flags getFlags() {
            return this.messageMetaData().getFlags();
        }

        public ModSeq getModSeq() {
            return this.messageMetaData().getModSeq();
        }

        public long getSize() {
            return this.messageMetaData().getSize();
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public Content getFullContent() throws MailboxException {
            throw this.exception;
        }

        public Content getBody() throws MailboxException {
            throw this.exception;
        }

        public boolean hasAttachments() throws MailboxException {
            throw this.exception;
        }

        public int compareTo(MessageResult that) {
            return this.getUid().compareTo(that.getUid());
        }

        public final boolean equals(Object o) {
            if (o instanceof UnloadedMessageResult) {
                UnloadedMessageResult that = (UnloadedMessageResult)o;
                return Objects.equals(this.exception, that.exception) && Objects.equals(this.getInternalDate(), that.getInternalDate()) && Objects.equals(this.getSize(), that.getSize()) && Objects.equals(this.getUid(), that.getUid()) && Objects.equals(this.getFlags(), that.getFlags()) && Objects.equals(this.getModSeq(), that.getModSeq()) && Objects.equals(this.messageId, that.messageId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.exception, this.getInternalDate(), this.getSize(), this.getUid(), this.getFlags(), this.getModSeq(), this.messageId);
        }

        public Content getFullContent(MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<Header> iterateHeaders(MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<Header> iterateMimeHeaders(MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getBody(MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getMimeBody(MimePath path) throws MailboxException {
            throw this.exception;
        }

        public MimeDescriptor getMimeDescriptor() throws MailboxException {
            throw this.exception;
        }

        public Headers getHeaders() throws MailboxException {
            throw this.exception;
        }

        public List<MessageAttachment> getLoadedAttachments() throws MailboxException {
            throw this.exception;
        }
    }
}

