/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.ReadOnlyException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxMetaData;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MoveResult;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMessageResultIterator;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.apache.james.util.BodyOffsetInputStream;
import org.apache.james.util.IteratorWrapper;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StoreMessageManager
implements MessageManager {
    protected static final Flags MINIMAL_PERMANET_FLAGS = new Flags();
    private static final Logger LOG;
    private final EnumSet<MailboxManager.MessageCapabilities> messageCapabilities;
    private final EventBus eventBus;
    private final Mailbox mailbox;
    private final MailboxSessionMapperFactory mapperFactory;
    private final MessageSearchIndex index;
    private final StoreRightManager storeRightManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final BatchSizes batchSizes;
    private final PreDeletionHooks preDeletionHooks;

    public StoreMessageManager(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities, MailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, EventBus eventBus, MailboxPathLocker locker, Mailbox mailbox, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, BatchSizes batchSizes, StoreRightManager storeRightManager, PreDeletionHooks preDeletionHooks) {
        this.messageCapabilities = messageCapabilities;
        this.eventBus = eventBus;
        this.mailbox = mailbox;
        this.mapperFactory = mapperFactory;
        this.index = index;
        this.locker = locker;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.batchSizes = batchSizes;
        this.storeRightManager = storeRightManager;
        this.preDeletionHooks = preDeletionHooks;
    }

    public Mailbox getMailboxEntity() throws MailboxException {
        return this.mailbox;
    }

    protected Flags getPermanentFlags(MailboxSession session) {
        return new Flags(MINIMAL_PERMANET_FLAGS);
    }

    public MailboxCounters getMailboxCounters(MailboxSession mailboxSession) throws MailboxException {
        if (this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return this.mapperFactory.createMessageMapper(mailboxSession).getMailboxCounters(this.mailbox);
        }
        return MailboxCounters.builder().mailboxId(this.mailbox.getMailboxId()).count(0L).unseen(0L).build();
    }

    protected Flags getSharedPermanentFlags(MailboxSession session) {
        return this.getPermanentFlags(session);
    }

    public boolean isModSeqPermanent(MailboxSession session) {
        return true;
    }

    public Iterator<MessageUid> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        List<MessageUid> uids = this.retrieveMessagesMarkedForDeletion(set, mailboxSession);
        Map<MessageUid, MessageMetaData> deletedMessages = this.deleteMessages(uids, mailboxSession);
        this.dispatchExpungeEvent(mailboxSession, deletedMessages);
        return deletedMessages.keySet().iterator();
    }

    private List<MessageUid> retrieveMessagesMarkedForDeletion(MessageRange messageRange, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(() -> messageMapper.retrieveMessagesMarkedForDeletion(this.getMailboxEntity(), messageRange));
    }

    public void delete(List<MessageUid> messageUids, MailboxSession mailboxSession) throws MailboxException {
        Map<MessageUid, MessageMetaData> deletedMessages = this.deleteMessages(messageUids, mailboxSession);
        this.dispatchExpungeEvent(mailboxSession, deletedMessages);
    }

    private Map<MessageUid, MessageMetaData> deleteMessages(List<MessageUid> messageUids, MailboxSession session) throws MailboxException {
        if (messageUids.isEmpty()) {
            return ImmutableMap.of();
        }
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        this.runPredeletionHooks(messageUids, session);
        return messageMapper.execute(() -> messageMapper.deleteMessages(this.getMailboxEntity(), messageUids));
    }

    private void dispatchExpungeEvent(MailboxSession mailboxSession, Map<MessageUid, MessageMetaData> deletedMessages) throws MailboxException {
        this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).metaData((SortedMap<MessageUid, MessageMetaData>)ImmutableSortedMap.copyOf(deletedMessages))).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())).block();
    }

    public ComposedMessageId appendMessage(MessageManager.AppendCommand appendCommand, MailboxSession session) throws MailboxException {
        return this.appendMessage(appendCommand.getMsgIn(), appendCommand.getInternalDate(), session, appendCommand.isRecent(), appendCommand.getFlags());
    }

    /*
     * Exception decompiling
     */
    public ComposedMessageId appendMessage(InputStream msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) throws MailboxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MimeTokenStream getParser(BodyOffsetInputStream bIn) {
        MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder());
        parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
        parser.parse((InputStream)bIn);
        return parser;
    }

    private MediaType getMediaType(MaximalBodyDescriptor descriptor) {
        String mediaTypeFromHeader = descriptor.getMediaType();
        if (mediaTypeFromHeader == null) {
            return new MediaType("text", "plain");
        }
        return new MediaType(mediaTypeFromHeader, descriptor.getSubType());
    }

    private HeaderImpl readHeader(MimeTokenStream parser) throws IOException, MimeException {
        HeaderImpl header = new HeaderImpl();
        EntityState next = parser.next();
        while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
            if (next == EntityState.T_FIELD) {
                header.addField(parser.getField());
            }
            next = parser.next();
        }
        return header;
    }

    private Flags getFlags(MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) {
        Flags flags;
        if (flagsToBeSet == null) {
            flags = new Flags();
        } else {
            flags = flagsToBeSet;
            this.trimFlags(flags, mailboxSession);
        }
        if (isRecent) {
            flags.add(Flags.Flag.RECENT);
        }
        return flags;
    }

    private void setTextualLinesCount(MimeTokenStream parser, String mediaType, PropertyBuilder propertyBuilder) throws IOException, MimeException {
        if ("text".equalsIgnoreCase(mediaType)) {
            CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
            bodyStream.readAll();
            long lines = bodyStream.getLineCount();
            bodyStream.close();
            EntityState next = parser.next();
            if (next == EntityState.T_EPILOGUE) {
                CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                epilogueStream.readAll();
                lines += (long)epilogueStream.getLineCount();
                epilogueStream.close();
            }
            propertyBuilder.setTextualLineCount(lines);
        }
    }

    private void consumeStream(BufferedOutputStream bufferedOut, BufferedInputStream tmpMsgIn) throws IOException {
        byte[] discard = new byte[4096];
        while (tmpMsgIn.read(discard) != -1) {
        }
        bufferedOut.flush();
    }

    private int getBodyStartOctet(BodyOffsetInputStream bIn) {
        int bodyStartOctet = (int)bIn.getBodyStartOffset();
        if (bodyStartOctet == -1) {
            bodyStartOctet = 0;
        }
        return bodyStartOctet;
    }

    private ComposedMessageId createAndDispatchMessage(Date internalDate, MailboxSession mailboxSession, File file, PropertyBuilder propertyBuilder, Flags flags, int bodyStartOctet) throws IOException, MailboxException {
        try (SharedFileInputStream contentIn = new SharedFileInputStream(file);){
            int size = (int)file.length();
            List<MessageAttachment> attachments = this.extractAttachments(contentIn);
            propertyBuilder.setHasAttachment(this.hasNonInlinedAttachment(attachments));
            MailboxMessage message = this.createMessage(internalDate, size, bodyStartOctet, (SharedInputStream)contentIn, flags, propertyBuilder, attachments);
            new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox).tryAddition(1L, size);
            ComposedMessageId composedMessageId = (ComposedMessageId)this.locker.executeWithLock(this.getMailboxPath(), () -> {
                MessageMetaData data = this.appendMessageToStore(message, attachments, mailboxSession);
                Mailbox mailbox = this.getMailboxEntity();
                this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).addMetaData(message.metaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).subscribeOn(Schedulers.elastic()).block();
                return new ComposedMessageId(mailbox.getMailboxId(), data.getMessageId(), data.getUid());
            }, MailboxPathLocker.LockType.Write);
            return composedMessageId;
        }
    }

    private PropertyBuilder getPropertyBuilder(MaximalBodyDescriptor descriptor, String mediaType, String subType) {
        String boundary;
        PropertyBuilder propertyBuilder = new PropertyBuilder();
        propertyBuilder.setMediaType(mediaType);
        propertyBuilder.setSubType(subType);
        propertyBuilder.setContentID(descriptor.getContentId());
        propertyBuilder.setContentDescription(descriptor.getContentDescription());
        propertyBuilder.setContentLocation(descriptor.getContentLocation());
        propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
        propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
        propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
        propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
        propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
        propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
        String codeset = descriptor.getCharset();
        if (codeset == null) {
            if ("TEXT".equalsIgnoreCase(mediaType)) {
                propertyBuilder.setCharset("us-ascii");
            }
        } else {
            propertyBuilder.setCharset(codeset);
        }
        if ((boundary = descriptor.getBoundary()) != null) {
            propertyBuilder.setBoundary(boundary);
        }
        return propertyBuilder;
    }

    private boolean hasNonInlinedAttachment(List<MessageAttachment> attachments) {
        return attachments.stream().anyMatch(messageAttachment -> !messageAttachment.isInlinedWithCid());
    }

    private List<MessageAttachment> extractAttachments(SharedFileInputStream contentIn) {
        try {
            return this.messageParser.retrieveAttachments((InputStream)contentIn);
        }
        catch (Exception e) {
            LOG.warn("Error while parsing mail's attachments: {}", (Object)e.getMessage(), (Object)e);
            return ImmutableList.of();
        }
    }

    protected MailboxMessage createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachment> attachments) throws MailboxException {
        return new SimpleMailboxMessage(this.messageIdFactory.generate(), internalDate, size, bodyStartOctet, content, flags, propertyBuilder, this.getMailboxEntity().getMailboxId(), attachments);
    }

    public boolean isWriteable(MailboxSession session) throws MailboxException {
        return this.storeRightManager.isReadWrite(session, this.mailbox, this.getSharedPermanentFlags(session));
    }

    public MessageManager.MetaData getMetaData(boolean resetRecent, MailboxSession mailboxSession, MessageManager.MetaData.FetchGroup fetchGroup) throws MailboxException {
        List<Object> recent;
        MessageUid firstUnseen;
        long messageCount;
        long unseenCount;
        MailboxACL resolvedAcl = this.getResolvedAcl(mailboxSession);
        boolean hasReadRight = this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession);
        if (!hasReadRight) {
            return MailboxMetaData.sensibleInformationFree(resolvedAcl, this.getMailboxEntity().getUidValidity(), this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession));
        }
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        UidValidity uidValidity = this.getMailboxEntity().getUidValidity();
        MessageUid uidNext = this.mapperFactory.getMessageMapper(mailboxSession).getLastUid(this.mailbox).map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
        ModSeq highestModSeq = this.mapperFactory.getMessageMapper(mailboxSession).getHighestModSeq(this.mailbox);
        switch (fetchGroup) {
            case UNSEEN_COUNT: {
                MailboxCounters mailboxCounters = this.getMailboxCounters(mailboxSession);
                unseenCount = mailboxCounters.getUnseen();
                messageCount = mailboxCounters.getCount();
                firstUnseen = null;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case FIRST_UNSEEN: {
                firstUnseen = this.findFirstUnseenMessageUid(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                unseenCount = 0L;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case NO_UNSEEN: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = this.getMessageCount(mailboxSession);
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            default: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = -1L;
                if (resetRecent) {
                    this.recent(resetRecent, mailboxSession);
                }
                recent = new ArrayList();
            }
        }
        return new MailboxMetaData(recent, permanentFlags, uidValidity, uidNext, highestModSeq, messageCount, unseenCount, firstUnseen, this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession), resolvedAcl);
    }

    public MailboxACL getResolvedAcl(MailboxSession mailboxSession) throws UnsupportedRightException {
        return this.storeRightManager.getResolvedMailboxACL(this.mailbox, mailboxSession);
    }

    private void trimFlags(Flags flags, MailboxSession session) {
        Flags.Flag[] systemFlags;
        Flags permFlags = this.getPermanentFlags(session);
        for (Flags.Flag f : systemFlags = flags.getSystemFlags()) {
            if (f == Flags.Flag.RECENT || permFlags.contains(f)) continue;
            flags.remove(f);
        }
        if (!permFlags.contains(Flags.Flag.USER)) {
            String[] uFlags;
            for (String uFlag : uFlags = flags.getUserFlags()) {
                if (permFlags.contains(uFlag)) continue;
                flags.remove(uFlag);
            }
        }
    }

    public Map<MessageUid, Flags> setFlags(Flags flags, MessageManager.FlagsUpdateMode flagsUpdateMode, MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        this.trimFlags(flags, mailboxSession);
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Iterator it = messageMapper.execute(() -> messageMapper.updateFlags(this.getMailboxEntity(), new FlagsUpdateCalculator(flags, flagsUpdateMode), set));
        List updatedFlags = (List)Iterators.toStream((Iterator)it).collect(Guavate.toImmutableList());
        this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).updatedFlags(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())).block();
        return (Map)updatedFlags.stream().collect(Guavate.toImmutableMap(UpdatedFlags::getUid, UpdatedFlags::getNewFlags));
    }

    public List<MessageRange> copyTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) throws MailboxException {
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException(toMailbox.getMailboxPath());
        }
        return (List)this.locker.executeWithLock(toMailbox.getMailboxPath(), () -> {
            SortedMap<MessageUid, MessageMetaData> copiedUids = this.copy(set, toMailbox, session);
            return MessageRange.toRanges(new ArrayList<MessageUid>(copiedUids.keySet()));
        }, MailboxPathLocker.LockType.Write);
    }

    public List<MessageRange> moveTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) throws MailboxException {
        if (!this.isWriteable(session)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException(toMailbox.getMailboxPath());
        }
        return (List)this.locker.executeWithLock(toMailbox.getMailboxPath(), () -> {
            SortedMap<MessageUid, MessageMetaData> movedUids = this.move(set, toMailbox, session);
            return MessageRange.toRanges(new ArrayList<MessageUid>(movedUids.keySet()));
        }, MailboxPathLocker.LockType.Write);
    }

    protected MessageMetaData appendMessageToStore(MailboxMessage message, List<MessageAttachment> messageAttachments, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return this.mapperFactory.getMessageMapper(session).execute(() -> {
            this.storeAttachment(message, messageAttachments, session);
            return messageMapper.add(this.getMailboxEntity(), message);
        });
    }

    protected void storeAttachment(MailboxMessage message, List<MessageAttachment> messageAttachments, MailboxSession session) throws MailboxException {
    }

    public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.getMessageMapper(mailboxSession).countMessagesInMailbox(this.getMailboxEntity());
    }

    public MessageResultIterator getMessages(MessageRange set, FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return new StoreMessageResultIterator(messageMapper, this.mailbox, set, this.batchSizes, fetchGroup);
    }

    protected List<MessageUid> recent(boolean reset, MailboxSession mailboxSession) throws MailboxException {
        if (reset && !this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.execute(() -> {
            List<MessageUid> members = messageMapper.findRecentMessageUidsInMailbox(this.getMailboxEntity());
            List ranges = MessageRange.toRanges(members);
            for (MessageRange range : ranges) {
                if (!reset) continue;
                messageMapper.updateFlags(this.getMailboxEntity(), new FlagsUpdateCalculator(new Flags(Flags.Flag.RECENT), MessageManager.FlagsUpdateMode.REMOVE), range);
            }
            return members;
        });
    }

    private void runPredeletionHooks(List<MessageUid> uids, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        PreDeletionHook.DeleteOperation deleteOperation = (PreDeletionHook.DeleteOperation)Flux.fromIterable((Iterable)MessageRange.toRanges(uids)).publishOn(Schedulers.elastic()).flatMap(range -> Mono.fromCallable(() -> messageMapper.findInMailbox(this.mailbox, (MessageRange)range, MessageMapper.FetchType.Metadata, -1)).flatMapMany(iterator -> Flux.fromStream((Stream)Iterators.toStream((Iterator)iterator)))).map(mailboxMessage -> MetadataWithMailboxId.from((MessageMetaData)mailboxMessage.metaData(), (MailboxId)mailboxMessage.getMailboxId())).collect(Guavate.toImmutableList()).map(PreDeletionHook.DeleteOperation::from).block();
        this.preDeletionHooks.runHooks(deleteOperation).block();
    }

    public Stream<MessageUid> search(SearchQuery query, MailboxSession mailboxSession) throws MailboxException {
        if (query.equals((Object)new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()}))) {
            return this.listAllMessageUids(mailboxSession);
        }
        return this.index.search(mailboxSession, this.getMailboxEntity(), query);
    }

    private Iterator<MessageMetaData> copy(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> copiedRows = new ArrayList<MessageMetaData>();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        while (originalRows.hasNext()) {
            MailboxMessage originalMessage = originalRows.next();
            new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox).tryAddition(1L, originalMessage.getFullContentOctets());
            MessageMetaData data = messageMapper.execute(() -> messageMapper.copy(this.getMailboxEntity(), originalMessage));
            copiedRows.add(data);
        }
        return copiedRows.iterator();
    }

    private MoveResult move(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> movedRows = new ArrayList<MessageMetaData>();
        ArrayList<MessageMetaData> originalRowsCopy = new ArrayList<MessageMetaData>();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        while (originalRows.hasNext()) {
            MailboxMessage originalMessage = originalRows.next();
            originalRowsCopy.add(originalMessage.metaData());
            MessageMetaData data = messageMapper.execute(() -> messageMapper.move(this.getMailboxEntity(), originalMessage));
            movedRows.add(data);
        }
        return new MoveResult(movedRows.iterator(), originalRowsCopy.iterator());
    }

    private SortedMap<MessageUid, MessageMetaData> copy(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        IteratorWrapper originalRows = new IteratorWrapper(this.retrieveOriginalRows(set, session));
        SortedMap<MessageUid, MessageMetaData> copiedUids = this.collectMetadata(to.copy((Iterator<MailboxMessage>)originalRows, session));
        ImmutableList.Builder messageIds = ImmutableList.builder();
        for (MailboxMessage message : originalRows.getEntriesSeen()) {
            messageIds.add((Object)message.getMessageId());
        }
        MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId(), this.getMailboxEntity().getMailboxId()}).build();
        Flux.concat((Publisher[])new Publisher[]{this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(session)).mailbox(to.getMailboxEntity())).metaData(copiedUids)).build(), (RegistrationKey)new MailboxIdRegistrationKey(to.getMailboxEntity().getMailboxId())), this.eventBus.dispatch((Event)EventFactory.moved().session(session).messageMoves(messageMoves).messageId((Iterable)messageIds.build()).build(), (Set)messageMoves.impactedMailboxIds().map(MailboxIdRegistrationKey::new).collect(Guavate.toImmutableSet()))}).blockLast();
        return copiedUids;
    }

    private SortedMap<MessageUid, MessageMetaData> move(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        IteratorWrapper originalRows = new IteratorWrapper(this.retrieveOriginalRows(set, session));
        MoveResult moveResult = to.move((Iterator<MailboxMessage>)originalRows, session);
        SortedMap<MessageUid, MessageMetaData> moveUids = this.collectMetadata(moveResult.getMovedMessages());
        ImmutableList.Builder messageIds = ImmutableList.builder();
        for (MailboxMessage message : originalRows.getEntriesSeen()) {
            messageIds.add((Object)message.getMessageId());
        }
        MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId()}).build();
        Flux.concat((Publisher[])new Publisher[]{this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(session)).mailbox(to.getMailboxEntity())).metaData(moveUids)).build(), (RegistrationKey)new MailboxIdRegistrationKey(to.getMailboxEntity().getMailboxId())), this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(session)).mailbox(this.getMailboxEntity())).addMetaData(moveResult.getOriginalMessages())).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())), this.eventBus.dispatch((Event)EventFactory.moved().messageMoves(messageMoves).messageId((Iterable)messageIds.build()).session(session).build(), (Set)messageMoves.impactedMailboxIds().map(MailboxIdRegistrationKey::new).collect(Guavate.toImmutableSet()))}).blockLast();
        return moveUids;
    }

    private Iterator<MailboxMessage> retrieveOriginalRows(MessageRange set, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findInMailbox(this.mailbox, set, MessageMapper.FetchType.Full, -1);
    }

    private SortedMap<MessageUid, MessageMetaData> collectMetadata(Iterator<MessageMetaData> ids) {
        TreeMap<MessageUid, MessageMetaData> copiedMessages = new TreeMap<MessageUid, MessageMetaData>();
        while (ids.hasNext()) {
            MessageMetaData data = ids.next();
            copiedMessages.put(data.getUid(), data);
        }
        return copiedMessages;
    }

    protected MessageUid findFirstUnseenMessageUid(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findFirstUnseenMessageUid(this.getMailboxEntity());
    }

    public MailboxId getId() {
        return this.mailbox.getMailboxId();
    }

    public MailboxPath getMailboxPath() throws MailboxException {
        return this.getMailboxEntity().generateAssociatedPath();
    }

    public Flags getApplicableFlags(MailboxSession session) throws MailboxException {
        return this.mapperFactory.getMessageMapper(session).getApplicableFlag(this.mailbox);
    }

    private Stream<MessageUid> listAllMessageUids(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(() -> Iterators.toStream(messageMapper.listAllMessageUids(this.mailbox)));
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return this.messageCapabilities;
    }

    static {
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.ANSWERED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DELETED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DRAFT);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.FLAGGED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.SEEN);
        LOG = LoggerFactory.getLogger(StoreMessageManager.class);
    }

    private static class MediaType {
        final String mediaType;
        final String subType;

        private MediaType(String mediaType, String subType) {
            this.mediaType = mediaType;
            this.subType = subType;
        }
    }
}

