/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.exception.InboxAlreadyCreated;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StoreMailboxManager
implements MailboxManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMailboxManager.class);
    public static final char SQL_WILDCARD_CHAR = '%';
    public static final EnumSet<MailboxManager.MessageCapabilities> DEFAULT_NO_MESSAGE_CAPABILITIES = EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    private final StoreRightManager storeRightManager;
    private final EventBus eventBus;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxAnnotationManager annotationManager;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final SessionProvider sessionProvider;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaComponents quotaComponents;
    private final MessageSearchIndex index;
    private final PreDeletionHooks preDeletionHooks;
    protected final MailboxManagerConfiguration configuration;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxAnnotationManager annotationManager, EventBus eventBus, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex searchIndex, MailboxManagerConfiguration configuration, PreDeletionHooks preDeletionHooks) {
        Preconditions.checkNotNull((Object)eventBus);
        Preconditions.checkNotNull((Object)mailboxSessionMapperFactory);
        this.annotationManager = annotationManager;
        this.sessionProvider = sessionProvider;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.eventBus = eventBus;
        this.storeRightManager = storeRightManager;
        this.quotaRootResolver = quotaComponents.getQuotaRootResolver();
        this.quotaManager = quotaComponents.getQuotaManager();
        this.quotaComponents = quotaComponents;
        this.index = searchIndex;
        this.configuration = configuration;
        this.preDeletionHooks = preDeletionHooks;
    }

    public QuotaComponents getQuotaComponents() {
        return this.quotaComponents;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return DEFAULT_NO_MESSAGE_CAPABILITIES;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities(this.getSupportedMessageCapabilities());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    public MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    public MessageParser getMessageParser() {
        return this.messageParser;
    }

    public PreDeletionHooks getPreDeletionHooks() {
        return this.preDeletionHooks;
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.sessionProvider.createSystemSession(userName);
    }

    public char getDelimiter() {
        return this.sessionProvider.getDelimiter();
    }

    public MailboxSession login(Username userid, String passwd) throws MailboxException {
        return this.sessionProvider.login(userid, passwd);
    }

    public MailboxSession loginAsOtherUser(Username adminUserid, String passwd, Username otherUserId) throws MailboxException {
        return this.sessionProvider.loginAsOtherUser(adminUserid, passwd, otherUserId);
    }

    public void logout(MailboxSession session) {
        this.sessionProvider.logout(session);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(DEFAULT_NO_MESSAGE_CAPABILITIES, this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailbox, this.quotaManager, this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.preDeletionHooks);
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = (Mailbox)mapper.findMailboxByPath(mailboxPath).blockOptional().orElseThrow(() -> {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxPath);
            return new MailboxNotFoundException(mailboxPath);
        });
        if (!this.assertUserHasAccessTo(mailboxRow, session)) {
            LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxPath, session.getUser(), mailboxRow.getUser()});
            throw new MailboxNotFoundException(mailboxPath);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxPath);
        return this.createMessageManager(mailboxRow, session);
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxById(mailboxId);
        if (mailboxRow == null) {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxId.serialize());
            throw new MailboxNotFoundException(mailboxId);
        }
        if (!this.assertUserHasAccessTo(mailboxRow, session)) {
            LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxId.serialize(), session.getUser(), mailboxRow.getUser()});
            throw new MailboxNotFoundException(mailboxId);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxId.serialize());
        return this.createMessageManager(mailboxRow, session);
    }

    private boolean assertUserHasAccessTo(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.belongsToCurrentUser(mailbox, session) || this.userHasLookupRightsOn(mailbox, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return mailbox.generateAssociatedPath().belongsTo(session);
    }

    private boolean userHasLookupRightsOn(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Lookup, session);
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        LOGGER.debug("createMailbox {}", (Object)mailboxPath);
        this.assertMailboxPathBelongToUser(mailboxSession, mailboxPath);
        if (mailboxPath.getName().isEmpty()) {
            LOGGER.warn("Ignoring mailbox with empty name");
        } else {
            MailboxPath sanitizedMailboxPath = mailboxPath.sanitize(mailboxSession.getPathDelimiter());
            sanitizedMailboxPath.assertAcceptable(mailboxSession.getPathDelimiter());
            if (((Boolean)this.mailboxExists(sanitizedMailboxPath, mailboxSession).block()).booleanValue()) {
                throw new MailboxExistsException(sanitizedMailboxPath.asString());
            }
            List<MailboxId> mailboxIds = this.createMailboxesForPath(mailboxSession, sanitizedMailboxPath);
            if (!mailboxIds.isEmpty()) {
                return Optional.ofNullable((MailboxId)Iterables.getLast(mailboxIds));
            }
        }
        return Optional.empty();
    }

    private List<MailboxId> createMailboxesForPath(MailboxSession mailboxSession, MailboxPath sanitizedMailboxPath) {
        List intermediatePaths = sanitizedMailboxPath.getHierarchyLevels(this.getDelimiter());
        boolean isRootPath = intermediatePaths.size() == 1;
        return (List)intermediatePaths.stream().flatMap(Throwing.function(mailboxPath -> this.manageMailboxCreation(mailboxSession, isRootPath, (MailboxPath)mailboxPath)).sneakyThrow()).collect(Guavate.toImmutableList());
    }

    private Stream<MailboxId> manageMailboxCreation(MailboxSession mailboxSession, boolean isRootPath, MailboxPath mailboxPath) throws MailboxException {
        if (mailboxPath.isInbox()) {
            if (((Boolean)Mono.from((Publisher)this.hasInbox(mailboxSession)).block()).booleanValue()) {
                return this.duplicatedINBOXCreation(isRootPath, mailboxPath);
            }
            return this.performConcurrentMailboxCreation(mailboxSession, MailboxPath.inbox((MailboxSession)mailboxSession)).stream();
        }
        return this.performConcurrentMailboxCreation(mailboxSession, mailboxPath).stream();
    }

    private Stream<MailboxId> duplicatedINBOXCreation(boolean isRootPath, MailboxPath mailbox) throws InboxAlreadyCreated {
        if (isRootPath) {
            throw new InboxAlreadyCreated(mailbox.getName());
        }
        return Stream.empty();
    }

    private List<MailboxId> performConcurrentMailboxCreation(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        ArrayList<MailboxId> mailboxIds = new ArrayList<MailboxId>();
        this.locker.executeWithLock(mailboxPath, () -> {
            if (!((Boolean)this.mailboxExists(mailboxPath, mailboxSession).block()).booleanValue()) {
                MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
                try {
                    mapper.execute(Mapper.toTransaction(() -> {
                        Mailbox mailbox = mapper.create(mailboxPath, UidValidity.generate());
                        mailboxIds.add(mailbox.getMailboxId());
                        this.eventBus.dispatch((Event)((EventFactory.MailboxAddedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxAdded().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
                    }));
                }
                catch (MailboxExistsException e) {
                    LOGGER.info("{} mailbox was created concurrently", (Object)mailboxPath.asString());
                }
            }
            return null;
        }, MailboxPathLocker.LockType.Write);
        return mailboxIds;
    }

    private void assertMailboxPathBelongToUser(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            throw new InsufficientRightsException("mailboxPath '" + mailboxPath.asString() + "' does not belong to user '" + mailboxSession.getUser().asString() + "'");
        }
    }

    public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        this.assertIsOwner(session, mailboxPath);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mailboxMapper.execute(() -> {
            Mailbox mailbox = mailboxMapper.findMailboxByPathBlocking(mailboxPath);
            return this.doDeleteMailbox(mailboxMapper, mailbox, session);
        });
    }

    public Mailbox deleteMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxId);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mailboxMapper.execute(() -> {
            Mailbox mailbox = mailboxMapper.findMailboxById(mailboxId);
            if (mailbox == null) {
                throw new MailboxNotFoundException(mailboxId);
            }
            this.assertIsOwner(session, mailbox.generateAssociatedPath());
            return this.doDeleteMailbox(mailboxMapper, mailbox, session);
        });
    }

    private Mailbox doDeleteMailbox(MailboxMapper mailboxMapper, Mailbox mailbox, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
        long messageCount = messageMapper.countMessagesInMailbox(mailbox);
        List metadata = (List)Iterators.toStream(messageMapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Metadata, -1)).map(message -> MetadataWithMailboxId.from((MessageMetaData)message.metaData(), (MailboxId)message.getMailboxId())).collect(Guavate.toImmutableList());
        long totalSize = metadata.stream().map(MetadataWithMailboxId::getMessageMetaData).mapToLong(MessageMetaData::getSize).sum();
        this.preDeletionHooks.runHooks(PreDeletionHook.DeleteOperation.from((List)metadata)).block();
        Mailbox m = new Mailbox(mailbox);
        mailboxMapper.delete(mailbox);
        this.eventBus.dispatch((Event)((EventFactory.MailboxDeletionFinalStage)((EventFactory.RequireQuotaSizeValue)((EventFactory.RequireQuotaCountValue)((EventFactory.RequireQuotaRoot)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxDeleted().randomEventId()).mailboxSession(session)).mailbox(mailbox)).quotaRoot(quotaRoot)).quotaCount(QuotaCountUsage.count((long)messageCount))).quotaSize(QuotaSizeUsage.size((long)totalSize))).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
        return m;
    }

    public void renameMailbox(MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)from, (Object)to);
        MailboxPath sanitizedMailboxPath = to.sanitize(session.getPathDelimiter());
        this.validateDestinationPath(sanitizedMailboxPath, session);
        this.assertIsOwner(session, from);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(Mapper.toTransaction(() -> {
            Mailbox mailbox = mapper.findMailboxByPathBlocking(from);
            this.doRenameMailbox(mailbox, sanitizedMailboxPath, session, mapper);
        }));
    }

    public void renameMailbox(MailboxId mailboxId, MailboxPath newMailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)mailboxId, (Object)newMailboxPath);
        MailboxPath sanitizedMailboxPath = newMailboxPath.sanitize(session.getPathDelimiter());
        this.validateDestinationPath(sanitizedMailboxPath, session);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(Mapper.toTransaction(() -> {
            Mailbox mailbox = Optional.ofNullable(mapper.findMailboxById(mailboxId)).orElseThrow(() -> new MailboxNotFoundException(mailboxId));
            this.assertIsOwner(session, mailbox.generateAssociatedPath());
            this.doRenameMailbox(mailbox, sanitizedMailboxPath, session, mapper);
        }));
    }

    private void validateDestinationPath(MailboxPath newMailboxPath, MailboxSession session) throws MailboxException {
        if (((Boolean)this.mailboxExists(newMailboxPath, session).block()).booleanValue()) {
            throw new MailboxExistsException(newMailboxPath.toString());
        }
        this.assertIsOwner(session, newMailboxPath);
        newMailboxPath.assertAcceptable(session.getPathDelimiter());
    }

    private void assertIsOwner(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxNotFoundException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            LOGGER.info("Mailbox {} does not belong to {}", (Object)mailboxPath.asString(), (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(mailboxPath.asString());
        }
    }

    private void doRenameMailbox(Mailbox mailbox, MailboxPath newMailboxPath, MailboxSession session, MailboxMapper mapper) throws MailboxException {
        MailboxPath from = mailbox.generateAssociatedPath();
        mailbox.setNamespace(newMailboxPath.getNamespace());
        mailbox.setUser(newMailboxPath.getUser());
        mailbox.setName(newMailboxPath.getName());
        mapper.rename(mailbox);
        this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(session).mailboxId(mailbox.getMailboxId()).oldPath(from).newPath(newMailboxPath).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
        MailboxQuery.UserBound query = MailboxQuery.builder().userAndNamespaceFrom(from).expression((MailboxNameExpression)new PrefixedWildcard(from.getName() + this.getDelimiter())).build().asUserBound();
        this.locker.executeWithLock(from, () -> {
            List<Mailbox> subMailboxes = mapper.findMailboxWithPathLike(query);
            for (Mailbox sub : subMailboxes) {
                String subOriginalName = sub.getName();
                String subNewName = newMailboxPath.getName() + subOriginalName.substring(from.getName().length());
                MailboxPath fromPath = new MailboxPath(from, subOriginalName);
                sub.setName(subNewName);
                mapper.rename(sub);
                this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(session).mailboxId(sub.getMailboxId()).oldPath(fromPath).newPath(sub.generateAssociatedPath()).build(), (RegistrationKey)new MailboxIdRegistrationKey(sub.getMailboxId())).block();
                LOGGER.debug("Rename mailbox sub-mailbox {} to {}", (Object)subOriginalName, (Object)subNewName);
            }
            return null;
        }, MailboxPathLocker.LockType.Write);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    private List<MessageRange> copyMessages(MessageRange set, MailboxSession session, StoreMessageManager toMailbox, StoreMessageManager fromMailbox) throws MailboxException {
        return this.configuration.getCopyBatcher().batchMessages(set, messageRange -> fromMailbox.copyTo(messageRange, toMailbox, session));
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.configuration.getMoveBatcher().batchMessages(set, messageRange -> fromMailbox.moveTo(messageRange, toMailbox, session));
    }

    public List<MailboxMetaData> search(MailboxQuery mailboxExpression, MailboxSession session) throws MailboxException {
        return this.searchMailboxesMetadata(mailboxExpression, session, MailboxACL.Right.Lookup);
    }

    private List<MailboxMetaData> searchMailboxesMetadata(MailboxQuery mailboxQuery, MailboxSession session, MailboxACL.Right right) throws MailboxException {
        List<Mailbox> mailboxes = this.searchMailboxes(mailboxQuery, session, right);
        ImmutableMap counters = (ImmutableMap)this.getMailboxCounters(mailboxes, session).stream().collect(Guavate.toImmutableMap(MailboxCounters::getMailboxId, (Function)Functions.identity()));
        return (List)mailboxes.stream().filter(arg_0 -> ((MailboxQuery)mailboxQuery).matches(arg_0)).map(Throwing.function(mailbox -> this.toMailboxMetadata(session, mailboxes, (Mailbox)mailbox, this.retrieveCounters((ImmutableMap<MailboxId, MailboxCounters>)counters, (Mailbox)mailbox))).sneakyThrow()).sorted(MailboxMetaData.COMPARATOR).collect(Guavate.toImmutableList());
    }

    private List<Mailbox> searchMailboxes(MailboxQuery mailboxQuery, MailboxSession session, MailboxACL.Right right) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Stream baseMailboxes = mailboxMapper.findMailboxWithPathLike(StoreMailboxManager.toSingleUserQuery(mailboxQuery, session)).stream();
        Stream<Mailbox> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, mailboxQuery, right, session);
        return (List)Stream.concat(baseMailboxes, delegatedMailboxes).distinct().filter((Predicate<Mailbox>)Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, right, session))).collect(Guavate.toImmutableList());
    }

    static MailboxQuery.UserBound toSingleUserQuery(MailboxQuery mailboxQuery, MailboxSession mailboxSession) {
        return MailboxQuery.builder().namespace(mailboxQuery.getNamespace().orElse("#private")).username(mailboxQuery.getUser().orElse(mailboxSession.getUser())).expression(mailboxQuery.getMailboxNameExpression().includeChildren()).build().asUserBound();
    }

    private MailboxCounters retrieveCounters(ImmutableMap<MailboxId, MailboxCounters> counters, Mailbox mailbox) {
        return (MailboxCounters)counters.getOrDefault((Object)mailbox.getMailboxId(), (Object)MailboxCounters.builder().mailboxId(mailbox.getMailboxId()).count(0L).unseen(0L).build());
    }

    private Stream<Mailbox> getDelegatedMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        if (mailboxQuery.isPrivateMailboxes(session)) {
            return Stream.of(new Mailbox[0]);
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser(), right).stream();
    }

    private MailboxMetaData toMailboxMetadata(MailboxSession session, List<Mailbox> mailboxes, Mailbox mailbox, MailboxCounters counters) throws UnsupportedRightException {
        return new MailboxMetaData(mailbox.generateAssociatedPath(), mailbox.getMailboxId(), this.getDelimiter(), this.computeChildren(session, mailboxes, mailbox), MailboxMetaData.Selectability.NONE, this.storeRightManager.getResolvedMailboxACL(mailbox, session), counters);
    }

    private MailboxMetaData.Children computeChildren(MailboxSession session, List<Mailbox> potentialChildren, Mailbox mailbox) {
        if (this.hasChildIn(mailbox, potentialChildren, session)) {
            return MailboxMetaData.Children.HAS_CHILDREN;
        }
        return MailboxMetaData.Children.HAS_NO_CHILDREN;
    }

    private boolean hasChildIn(Mailbox parentMailbox, List<Mailbox> mailboxesWithPathLike, MailboxSession mailboxSession) {
        return mailboxesWithPathLike.stream().anyMatch(mailbox -> mailbox.isChildOf(parentMailbox, mailboxSession));
    }

    public List<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) throws MailboxException {
        ImmutableSet wantedMailboxesId = (ImmutableSet)this.getInMailboxes((ImmutableSet<MailboxId>)expression.getInMailboxes(), session).filter(id -> !expression.getNotInMailboxes().contains(id)).collect(Guavate.toImmutableSet());
        return this.index.search(session, (Collection<MailboxId>)wantedMailboxesId, expression.getSearchQuery(), limit);
    }

    private Stream<MailboxId> getInMailboxes(ImmutableSet<MailboxId> inMailboxes, MailboxSession session) throws MailboxException {
        if (inMailboxes.isEmpty()) {
            return this.getAllReadableMailbox(session);
        }
        return this.getAllReadableMailbox(session).filter(arg_0 -> inMailboxes.contains(arg_0));
    }

    private Stream<MailboxId> getAllReadableMailbox(MailboxSession session) throws MailboxException {
        return this.searchMailboxes(MailboxQuery.builder().matchesAllMailboxNames().build(), session, MailboxACL.Right.Read).stream().map(Mailbox::getMailboxId);
    }

    public Mono<Boolean> mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxByPath(mailboxPath).hasElement();
    }

    public void endProcessingRequest(MailboxSession session) {
        this.mailboxSessionMapperFactory.endProcessingRequest(session);
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        return (List)this.mailboxSessionMapperFactory.getMailboxMapper(session).list().stream().map(Mailbox::generateAssociatedPath).distinct().collect(Guavate.toImmutableList());
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxPath, right, session);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxId, right, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxPath, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxId, session);
    }

    public MailboxACL.Rfc4314Rights[] listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, key, session);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, session);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxPath, mailboxACLCommand, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxPath, mailboxACL, session);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxId, mailboxACL, session);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.annotationManager.getAllAnnotations(mailboxPath, session);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeys(mailboxPath, session, keys);
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        this.annotationManager.updateAnnotations(mailboxPath, session, mailboxAnnotations);
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithOneDepth(mailboxPath, session, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithAllDepth(mailboxPath, session, keys);
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPathBlocking(mailboxPath);
        return mapper.hasChildren(mailbox, session.getPathDelimiter());
    }

    private List<MailboxCounters> getMailboxCounters(Collection<Mailbox> mailboxes, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        return messageMapper.getMailboxCounters((Collection)mailboxes.stream().filter(Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, MailboxACL.Right.Read, session)).sneakyThrow()).collect(Guavate.toImmutableList()));
    }
}

