/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.steveash.guavate.Guavate;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAttachmentManager
implements AttachmentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreAttachmentManager.class);
    private final AttachmentMapperFactory attachmentMapperFactory;
    private final MessageIdManager messageIdManager;

    @Inject
    public StoreAttachmentManager(AttachmentMapperFactory attachmentMapperFactory, MessageIdManager messageIdManager) {
        this.attachmentMapperFactory = attachmentMapperFactory;
        this.messageIdManager = messageIdManager;
    }

    public boolean exists(AttachmentId attachmentId, MailboxSession session) throws MailboxException {
        return this.userHasAccessToAttachment(attachmentId, session);
    }

    public Attachment getAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException, AttachmentNotFoundException {
        if (!this.userHasAccessToAttachment(attachmentId, mailboxSession)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachment(attachmentId);
    }

    public List<Attachment> getAttachments(List<AttachmentId> attachmentIds, MailboxSession mailboxSession) throws MailboxException {
        List accessibleAttachmentIds = (List)attachmentIds.stream().filter(attachmentId -> this.userHasAccessToAttachment((AttachmentId)attachmentId, mailboxSession)).collect(Guavate.toImmutableList());
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachments(accessibleAttachmentIds);
    }

    public Publisher<Void> storeAttachment(Attachment attachment, MailboxSession mailboxSession) {
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).storeAttachmentForOwner(attachment, mailboxSession.getUser());
    }

    public void storeAttachmentsForMessage(Collection<Attachment> attachments, MessageId ownerMessageId, MailboxSession mailboxSession) throws MailboxException {
        this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).storeAttachmentsForMessage(attachments, ownerMessageId);
    }

    private boolean userHasAccessToAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) {
        try {
            return this.isExplicitlyAOwner(attachmentId, mailboxSession) || this.isReferencedInUserMessages(attachmentId, mailboxSession);
        }
        catch (MailboxException e) {
            LOGGER.warn("Error while checking attachment related accessible message ids", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isReferencedInUserMessages(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        Collection<MessageId> relatedMessageIds = this.getRelatedMessageIds(attachmentId, mailboxSession);
        return !this.messageIdManager.accessibleMessages(relatedMessageIds, mailboxSession).isEmpty();
    }

    private boolean isExplicitlyAOwner(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        Collection<Username> explicitOwners = this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getOwners(attachmentId);
        return explicitOwners.stream().anyMatch(username -> mailboxSession.getUser().equals(username));
    }

    private Collection<MessageId> getRelatedMessageIds(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getRelatedMessageIds(attachmentId);
    }
}

