/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.PartContentDescriptor;
import org.apache.james.mailbox.store.MessageResultImpl;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.streaming.PartContentBuilder;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class ResultUtils {
    public static List<Header> createHeaders(MailboxMessage document) throws IOException {
        final ArrayList<Header> results = new ArrayList<Header>();
        final MimeStreamParser parser = new MimeStreamParser(MimeConfig.PERMISSIVE);
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(Field field) throws MimeException {
                String fieldValue;
                if (field instanceof RawField) {
                    int off;
                    ByteSequence raw = field.getRaw();
                    int len = raw.length();
                    if (len > (off = ((RawField)field).getDelimiterIdx() + 1) + 1 && (raw.byteAt(off) & 0xFF) == 32) {
                        ++off;
                    }
                    fieldValue = ContentUtil.decode((ByteSequence)raw, (int)off, (int)(len - off));
                } else {
                    fieldValue = field.getBody();
                }
                if (fieldValue.endsWith("\r\f")) {
                    fieldValue = fieldValue.substring(0, fieldValue.length() - 2);
                }
                if (fieldValue.startsWith(" ")) {
                    fieldValue = fieldValue.substring(1);
                }
                Header header = new Header(field.getName(), fieldValue);
                results.add(header);
            }
        });
        try {
            parser.parse(document.getHeaderContent());
        }
        catch (MimeException e) {
            throw new IOException("Unable to parse headers of message " + document, e);
        }
        return results;
    }

    public static MessageResult loadMessageResult(MailboxMessage message, FetchGroup fetchGroup) throws MailboxException {
        try {
            MessageResultImpl messageResult = new MessageResultImpl(message);
            if (fetchGroup != null) {
                if (!ResultUtils.haveValidContent(fetchGroup)) {
                    throw new UnsupportedOperationException("Unsupported result: " + fetchGroup.profiles());
                }
                ResultUtils.addPartContent(fetchGroup, message, messageResult);
            }
            return messageResult;
        }
        catch (IOException | MimeException e) {
            throw new MailboxException("Unable to parse message", e);
        }
    }

    @VisibleForTesting
    static boolean haveValidContent(FetchGroup fetchGroup) {
        EnumSet<FetchGroup.Profile> supportedGroups = EnumSet.of(FetchGroup.Profile.HEADERS, FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT, FetchGroup.Profile.MIME_DESCRIPTOR);
        Collection unsupportedProfiles = (Collection)fetchGroup.profiles().stream().filter(value -> !supportedGroups.contains(value)).collect(Guavate.toImmutableSet());
        return unsupportedProfiles.isEmpty();
    }

    private static void addPartContent(FetchGroup fetchGroup, MailboxMessage message, MessageResultImpl messageResult) throws MailboxException, IOException, MimeException {
        Set partContent = fetchGroup.getPartContentDescriptors();
        if (partContent != null) {
            for (PartContentDescriptor descriptor : partContent) {
                ResultUtils.addPartContent(descriptor, message, messageResult);
            }
        }
    }

    private static void addPartContent(PartContentDescriptor descriptor, MailboxMessage message, MessageResultImpl messageResult) throws MailboxException, IOException, MimeException {
        MimePath mimePath = descriptor.path();
        EnumSet profiles = descriptor.profiles();
        if (profiles.contains(FetchGroup.Profile.FULL_CONTENT)) {
            ResultUtils.addFullContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.BODY_CONTENT)) {
            ResultUtils.addBodyContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.MIME_CONTENT)) {
            ResultUtils.addMimeBodyContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.HEADERS)) {
            ResultUtils.addHeaders(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.MIME_HEADERS)) {
            ResultUtils.addMimeHeaders(message, messageResult, mimePath);
        }
    }

    private static PartContentBuilder build(int[] path, MailboxMessage message) throws IOException, MimeException {
        InputStream stream = message.getFullContent();
        PartContentBuilder result = new PartContentBuilder();
        result.parse(stream);
        try {
            for (int next : path) {
                result.to(next);
            }
        }
        catch (PartContentBuilder.PartNotFoundException e) {
            result.markEmpty();
        }
        return result;
    }

    private static int[] path(MimePath mimePath) {
        if (mimePath == null) {
            return null;
        }
        return mimePath.getPositions();
    }

    private static void addHeaders(MailboxMessage message, MessageResultImpl messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            List<Header> headers = builder.getMessageHeaders();
            messageResult.setHeaders(mimePath, headers.iterator());
        }
    }

    private static void addMimeHeaders(MailboxMessage message, MessageResultImpl messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            List<Header> headers = builder.getMimeHeaders();
            messageResult.setMimeHeaders(mimePath, headers.iterator());
        }
    }

    private static void addBodyContent(MailboxMessage message, MessageResultImpl messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            Content content = builder.getMessageBodyContent();
            messageResult.setBodyContent(mimePath, content);
        }
    }

    private static void addMimeBodyContent(MailboxMessage message, MessageResultImpl messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        PartContentBuilder builder = ResultUtils.build(path, message);
        Content content = builder.getMimeBodyContent();
        messageResult.setMimeBodyContent(mimePath, content);
    }

    private static void addFullContent(MailboxMessage message, MessageResultImpl messageResult, MimePath mimePath) throws MailboxException, IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            Content content = builder.getFullContent();
            messageResult.setFullContent(mimePath, content);
        }
    }
}

