/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PreDeletionHooks {
    private static final int CONCURRENCY = 1;
    public static final PreDeletionHooks NO_PRE_DELETION_HOOK = new PreDeletionHooks((Set<PreDeletionHook>)ImmutableSet.of(), Optional.empty());
    static final String PRE_DELETION_HOOK_METRIC_NAME = "preDeletionHook";
    private final Set<PreDeletionHook> hooks;
    private final Optional<MetricFactory> metricFactory;

    @Inject
    public PreDeletionHooks(Set<PreDeletionHook> hooks, MetricFactory metricFactory) {
        this(hooks, Optional.of(metricFactory));
    }

    private PreDeletionHooks(Set<PreDeletionHook> hooks, Optional<MetricFactory> metricFactory) {
        this.hooks = hooks;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> runHooks(PreDeletionHook.DeleteOperation deleteOperation) {
        return Flux.fromIterable(this.hooks).publishOn(Schedulers.elastic()).flatMap(hook -> (Publisher)this.metricFactory.map(factory -> this.publishMetric(deleteOperation, (PreDeletionHook)hook, (MetricFactory)factory)).orElse(Mono.empty()), 1).then();
    }

    private Mono<Void> publishMetric(PreDeletionHook.DeleteOperation deleteOperation, PreDeletionHook hook, MetricFactory factory) {
        return Mono.from((Publisher)factory.runPublishingTimerMetric(PRE_DELETION_HOOK_METRIC_NAME, hook.notifyDelete(deleteOperation)));
    }
}

