/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;

public class LazyMimeDescriptor
implements MimeDescriptor {
    private final Message message;
    private final MessageResult result;
    private PropertyBuilder pbuilder;

    public LazyMimeDescriptor(MessageResult result, Message message) {
        this.message = message;
        this.result = result;
    }

    public Iterator<Header> headers() throws MailboxException {
        return this.result.getHeaders().headers();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.result.getHeaders().getInputStream();
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve content", e);
        }
    }

    public long size() throws MailboxException {
        return this.result.getHeaders().size();
    }

    public String getMimeType() {
        return this.message.getMediaType();
    }

    public String getMimeSubType() {
        return this.message.getSubType();
    }

    public String getContentID() {
        return this.getPropertyBuilder().getContentID();
    }

    public String getContentDescription() {
        return this.getPropertyBuilder().getContentDescription();
    }

    public String getContentLocation() {
        return this.getPropertyBuilder().getContentLocation();
    }

    public String getContentMD5() {
        return this.getPropertyBuilder().getContentMD5();
    }

    public String getTransferContentEncoding() {
        return this.getPropertyBuilder().getContentTransferEncoding();
    }

    public List<String> getLanguages() {
        return this.getPropertyBuilder().getContentLanguage();
    }

    public String getDisposition() {
        return this.getPropertyBuilder().getContentDispositionType();
    }

    public Map<String, String> getDispositionParams() {
        return this.getPropertyBuilder().getContentDispositionParameters();
    }

    public long getLines() {
        Long count = this.message.getTextualLineCount();
        if (count == null) {
            return -1L;
        }
        return count;
    }

    public long getBodyOctets() {
        return this.message.getBodyOctets();
    }

    public Iterator<MimeDescriptor> parts() {
        return Collections.emptyIterator();
    }

    public MimeDescriptor embeddedMessage() {
        return null;
    }

    public Map<String, String> contentTypeParameters() {
        return this.getPropertyBuilder().getContentTypeParameters();
    }

    private PropertyBuilder getPropertyBuilder() {
        if (this.pbuilder == null) {
            this.pbuilder = new PropertyBuilder(this.message.getProperties());
        }
        return this.pbuilder;
    }
}

