# Upgrade instructions

This document covers every changes an Ops needs to be aware of when running James.

The following procedures are to take as it, and the Apache Software Foundation, nor its contributors, can not be 
responsible for any damages generated by following the below procedures.

Before performing these operations, you should ensure to have the skills to conduct the operations, and you should read other
software documentation. Do not follow this guide blindly!

## 3.5.0 version

Changes to apply between 3.4.0 and 3.5.0 are reported here.

Change list:

 - [LinShare blob export mechanism should rely on delegation](#LinShare blob export mechanism should rely on delegation)
 - [RabbitMQ minimal version](#rabbitmq-minimal-version)
 - [Enforce usernames to be lower cased](#enforce-usernames-to-be-lower-cased)
 - [Cassandra keyspace creation configuration](#cassandra-keyspace-creation-configuration)
 - [UsersFileRepository](#usersfilerepository)
 - [ElasticSearch performance enhancements](#elasticsearch-performance-enhancements)
 - [JAMES-2703 Post 3.4.0 release removals](#james-2703-post-340-release-removals)
 - [Health checks routes return code changes](#health-checks-routes-return-code-changes)
 - [User mailboxes reIndexing endpoint change](#user-mailboxes-reindexing-endpoint-change)
 - [Hybrid blobStore replaces Union blobStore](#hybrid-blobstore-replaces-union-blobstore)
 - [New forbidden set of characters in Usernames local part](#new-forbidden-set-of-characters-in-usernames-local-part)
 - [UidValidity and maildir](#uid-validity-and-maildir)
 - [UidValidity and JPA or Cassandra](#uid-validity-and-jpa-or-cassandra)
 - [Differentiation between domain alias and domain mapping](#differentiation-between-domain-alias-and-domain-mapping)
 - [ProtocolSession storng typing](#protocolsession-storng-typing)
 - [Tune Cassandra time serie tables options](#tune-cassandra-time-serie-tables-options)
 - [Log4J2 Adoption](#log4j2-adoption)

### Log4J2 Adoption

Date 20/03/2020

SHA-1 7682112258dc2e0b7322bfcf9cb44c1d287af422

JIRA: https://issues.apache.org/jira/browse/JAMES-3122

Concerned product: Spring

As Log4J 1.x is not compatible with Java 9+ runtime, we adopted Log4J2 as a logging solution for the Spring product.

As a consequence, the log configuration file for Spring product needs to be updated. See an example 
[here](server/app/src/main/resources/log4j2.xml).

Also, the deprecated `LogEnabled` API will be removed. We recommend extension developers to obtain their
Logger instance using the SLF4J `LoggerFactory` class instead.

### Tune Cassandra time serie tables options

Date 18/03/2020

SHA-1 bd6074cb689517061ecef9ddca3ab7a88d133cda

JIRA: https://issues.apache.org/jira/browse/JAMES-3121

Impacted product: Guice distributed James

Our usage of Cassandra for the time series have been improved by fine tuning the compaction strategy and
the read repair option.

#### Upgrade procedure

In order to unlock these improvements we advise you running the following commands on existing instalations

```
ALTER TABLE james_keyspace.deletedMailsV2 WITH compaction = { 'class' :  'TimeWindowCompactionStrategy'  };
ALTER TABLE james_keyspace.enqueuedMailsV3 WITH  compaction = {'compaction_window_size': '1',
                                                               'compaction_window_unit': 'HOURS',
                                                               'class': 'org.apache.cassandra.db.compaction.TimeWindowCompaction' };
ALTER TABLE james_keyspace.applicableFlag WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.attachmentMessageId WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.attachmentV2 WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.firstUnseen WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.mailboxCounters WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.mailboxRecents WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.messageCounter WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.messageDeleted WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.modseq WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.imapUidTable WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.messageIdTable WITH compaction = { 'class' :  'SizeTieredCompactionStrategy'  };
ALTER TABLE james_keyspace.eventStore WITH compaction = { 'class' :  'LeveledCompactionStrategy'  };
ALTER TABLE james_keyspace.attachmentOwners WITH bloom_filter_fp_chance = 0.01;
ALTER TABLE james_keyspace.deletedMailsV2 WITH bloom_filter_fp_chance = 0.01;
ALTER TABLE james_keyspace.firstUnseen WITH bloom_filter_fp_chance = 0.01;
ALTER TABLE james_keyspace.mailboxCounters WITH bloom_filter_fp_chance = 0.01;
ALTER TABLE james_keyspace.messageCounter WITH bloom_filter_fp_chance = 0.01;
ALTER TABLE james_keyspace.deletedMailsV2 WITH read_repair_chance = 0.0;
ALTER TABLE james_keyspace.enqueuedMailsV3 WITH read_repair_chance = 0.0;
```

### ProtocolSession strong typing

Date 19/03/2020

SHA-1 58b1d879ab

JIRA: https://issues.apache.org/jira/browse/JAMES-3119

`ProtocolSession` have been reworked in order to increase type strengh
and reduce errors.

Now `setAttachment` and `getAttachment` are expecting an `AttachmentKey` as key
and return an `Optional` instead of a `null`-able value.

Moreover `setAttachment` do not allow `null` values and `removeAttachment`
should be use now to remove elements.

### Differentiation between domain alias and domain mapping

Date 10/03/2020

SHA-1 81139cd94211358ca6a31b75b56c11b20e894ee4

JIRA: https://issues.apache.org/jira/browse/JAMES-3112

Concerned products: Guice products

We added strong typing for Domain aliases (exposed by this 
[endpoint](https://github.com/apache/james-project/blob/master/src/site/markdown/server/manage-webadmin.md#get-the-list-of-aliases-for-a-domain))
to distinguish them from domain mappings (exposed by this 
[endpoint](https://github.com/apache/james-project/blob/master/src/site/markdown/server/manage-webadmin.md#creating-address-domain-aliases)).

Read [this page](https://james.apache.org/server/config-recipientrewritetable.html) to understand the difference between 
Domain Alias and Domain Mapping.

As a consequence, existing values returned by the domain alias endpoint (before this fix this is domain mapping) will be 
considered as domain mappings and might need to be deleted and re-created.
 
### UidValidity and JPA or Cassandra

Date 26/02/2020

SHA-1 930fd38717b67f753b96f8b0595e80af7903298a

JIRA: https://issues.apache.org/jira/browse/JAMES-3074

Concerned products: JPA mailbox backend, Cassandra mailbox backend

Non-Maildir backends could generate '0' uid validity with a low probability, which is invalid regarding RFC-3501. 
We changed the generation mechanism to use valid UidValidity for newly created mailboxes. Regarding persisted mailboxes,
we regenerate invalid UidValidity upon reads.

While this sanitizing is transparent to the end user and the admin, it might lead to rare IMAP client full mailbox
 resynchronisation. (one chance out of two billions).

### UidValidity and maildir

Date 26/02/2020

SHA-1 837299290848cdc11a90c2e73c4af549a0f1106f

JIRA: https://issues.apache.org/jira/browse/JAMES-3074

Concerned products: Spring with maildir backend

Maildir generated too big values to conform to RFC-3501. We changed the generation mechanism to use valid UidValidity 
for newly created mailboxes. Regarding persisted mailboxes, we regenerate invalid UidValidity upon reads.

While this sanitizing is transparent to the end user and the admin, it might lead to IMAP client full resynchronisation.
 
### New forbidden set of characters in Usernames local part

Date 04/02/2020

SHA-1 4ebddfc107f7f47c29ff1d25dd045f314ff28672

JIRA: https://issues.apache.org/jira/browse/JAMES-2950

Even if this set of characters should be allowed for the local part of a Username regarding some context, as defined by the [RFC3696#section-3](https://tools.ietf.org/html/rfc3696#section-3), we decided that for reducing code complexity and more safety to not allow them anymore when creating new Usernames.

However, the read of Usernames already existing with some of those characters is still allowed, to not introduce any breaking change.

### LinShare blob export mechanism should rely on delegation
Date 12/02/2020

SHA-1 2422d3ef92a6c74e9da233039613d38fd833e632

Concerned products: Guice server, experimental LinShare blob export feature.

JIRA: https://issues.apache.org/jira/browse/JAMES-3040

Blob Export Configuration changed:

File configuration need to be adjusted: `blob.properties`

-You need to add new mandatory properties when `blob.export.implementation` property is set to `linshare`:
```
blob.export.linshare.technical.account.uuid
blob.export.linshare.technical.account.password
```

-The legacy property `blob.export.linshare.token` will not used anymore, you can remove it.
### Hybrid blobStore replaces Union blobStore

Date 6/01/2020

SHA-1 b44bc7d93901773ad442a341cb1ba2d94848c449

Concerned products: Guice distributed James server

Union blobStore, allowing to store older blobs within Cassandra while storing new blobs into object storage, had been removed.

Hybrid blobStore had been replacing it, allowing to store blobs either in a low cost blobStore or in a high performance blobStore, allowing thus some performance 
improvement for small, often read blobs while big or unfrequently read blobs keeps being stored cheaply.

Users relying on the Union blobStore will need to adopt Hybrid blobStore. Please adjust "blob.properties" accordingly:

```
implementation=hybrid
```

### User mailboxes reIndexing endpoint change
 
Date 16/12/2019

SHA-1 d68a64d96ba8312ecbd34761e82c9c2c32348290

Concerned products: Guice products

In an effort to have a resource oriented webadmin REST API we decided to relocate the endpoint for user mailbox reIndexing.

`curl -XPOST /mailboxes?task=reIndex&user=bob@apache.org`

Had been moved to:

`curl -XPOST /users/bob@apache.org/mailboxes?task=reIndex`

#### Health checks routes return code changes

Date 10/12/2019

SHA-1 cdbc0ee65f

Concerned products: Guice products

Health check return codes had been changed:
 - Degraded James server will now answer 200 instead of 500. JSON payload needs to be read in order to act upon a degraded server.
 - Unhealthy James server will now answer 503 instead of 500.
 
Depending on specific deployment usage of health-checks, management scripts might need to be updated.

#### RabbitMQ minimal version

Date 26/11/2019

SHA-1 0bf4e8384e

Concerned products: Guice distributed James (rabbitMQ)

The distributed James project (relying on Guice, Cassandra, ElasticSearch, RabbitMQ and optionally Swift) benefits from a new distributed task mananger.

In order to enforce task sequential processing at the cluster level, we rely on a single active consumer, which is a feature introduced in RabbitMQ 3.8.

Users of distributed James product thus need to upgrade their RabbitMQ server to be at least version 3.8.

#### Enforce usernames to be lower cased

Date 21/11/2019

SHA-1 9e976d3f49

JIRA: https://issues.apache.org/jira/browse/JAMES-2949

Many users recently complained about mails non received when sending to upper cased local recipients. We decided to simplify the handling of case for local recipients and users by always storing them lower cased.
Now all the users repositories are storing user in lower case to ensure that. If you previously used to store users in a case sensitive way (which is very unlikely as it is broking delivery), you could need to update your user database to lower case all your users.

#### Cassandra keyspace creation configuration

Date 15/11/2019

SHA-1 bcf4d36500

In order to allow the usage of cassandra credentials limited to a keyspace, the default behaviour of James is now to NOT
create the keyspace during start-up.

The automatic creation of the cassandra keyspace by James could be enabled by setting
 `cassandra.keyspace.create=true` in the `cassandra.properties` configuration file.
 
#### UsersFileRepository

Date 08/11/2019

SHA-1 0f8ee6ce2a

This specific user store was deprecated for years. It relied on Java serialization to store directly core.User object.

If you are still using it, you should instead use an [other user repository](https://james.apache.org/server/config-users.html).

If you need to export data from it, please [contact us](http://james.apache.org/#second), it could be possible to write a little extraction tool.

### ElasticSearch performance enhancements

Date 10/10/2019

SHA-1 0d72783ff4

JIRAS:
 - https://issues.apache.org/jira/browse/JAMES-2917
 - https://issues.apache.org/jira/browse/JAMES-2078
 - https://issues.apache.org/jira/browse/JAMES-2079
 - https://issues.apache.org/jira/browse/JAMES-2910

Concerned product: Guice product relying on ElasticSearch

We significantly improved our usage of ElasticSearch. Underlying changes include:

 - The use of routing to collocate emails of a same mailbox within a same shard. This enables search queries to avoid cluster
 level synchronisation, and thus enhance throughput, latencies and scalability.
 - Disabling dynamic mapping. We now represent headers as nested objects.
 - Removing some not needed fields from the mapping
 - No longer index raw HTML. This was possible under some configuration combination, and caused the data stored in elasticSearch
 to be significantly larger than required.

The downside of these changes is that a reindex is needed, implying a downtime on search:
 - Delete the indexes used by James
 - Start James in order to create the missing indexes
 - Trigger a [Full ReIndexing](https://james.apache.org/server/manage-webadmin.html#ReIndexing_all_mails), which can take
  time to complete.
 
#### JAMES-2703 Post 3.4.0 release removals

Date: 25/09/2019

SHA-1: f721747edf8deb50406a5a44f6476507a03e2543

JIRA: https://issues.apache.org/jira/browse/JAMES-2703

Concerned products: Spring, default bundled mailets

- Classes marked as deprecated whose removal was planned after 3.4.0 release (See JAMES-2703) had been removed. 

This includes:
  - SieveDefaultRepository. Please use SieveFileRepository instead.
  - JDBCRecipientRewriteTable, XMLRecipientRewriteTable, UsersRepositoryAliasingForwarding, JDBCAlias mailets. Please use RecipientRewriteTable mailet instead.
  - JDBCRecipientRewriteTable implementation. Please use JPARecipientRewriteTable instead.
  - JamesUsersJdbcRepository, DefaultUsersJdbcRepository. Please use JpaUsersRepository instead.
  - MailboxQuotaFixed matcher. Please use IsOverQuota instead.

## 3.4.0 version

Changes to apply between 3.3.x and 3.4.x will be reported here.

Change list:

 - [Upgrade to ElasticSearch 6.3](#upgrade-to-elasticsearch-63)
 - [Enqueuing several times a mail with the same name](#enqueuing-several-times-a-mail-with-the-same-name)
 - [RabbitMQ Mail Queue with multiple specific headers for a single recipient](#rabbitmq-mail-queue-with-multiple-specific-headers-for-a-single-recipient)

#### RabbitMQ Mail Queue with multiple specific headers for a single recipient

Date: 31/07/2019

SHA-1: f19642aef4a67cd6675f66278792ba4aa85d6d6e

JIRA: https://issues.apache.org/jira/browse/JAMES-2850

Concerned products: (experimental) RabbitMQ MailQueue

RabbitMQ MailQueue projection in Cassandra relies on a map allowing a single specific header per recipient header. This
limitation causes rejection of emails with multiple per-recipient headers (which happens when forwarding to a remote server
a mail checked against SpamAssassin).

In order to fix this issue, the structure of the underlying table was updated. A new table is created upon the first startup
following the upgrade, and the old one is ignored.

Impact: the mails enqueued before the update can not be browsed nor removed from the queue after the update.

Recommendation: Conduct this update with an empty mail queue.

To do so:

 - Given a distributed Guice James server
 - Stop incoming traffic
 - Monitor the mailQueues and wait them to be empty (spool & outgoing)
 - Once empty, upgrade James server and re-enable incoming traffic.

#### Enqueuing several times a mail with the same name

Date: XX/06/2019

SHA-1: XXXXX

JIRA: https://issues.apache.org/jira/browse/JAMES-2794

Concerned products: (experimental) RabbitMQ MailQueue

RabbitMQ mail queue combines RabbitMQ with projections in Cassandra to offer advanced management capabilities expected from
a mail queue (browse, delete, size, clear). In these projections, the mails are identified by there name. Thus enqueuing a
mail that had already been processed will lead the given email to be considered already deleted and it will be discarded 
and lost.

This is an issue, as several other components build features around submitting a mail several time with the name. 

For instance:

 - MailRepository reprocessing
 - RemoteDelivery bouncing under some configurations
 - RecipientRewriteTable rewriting to a remote server

We thus changed the table structure of RabbitMQ mail queue projections to be built around an EnqueueId. This additional 
level of indirection allows several enqueues with the same name.

Upgrade to the newest James server needs to be performed with an empty MailQueue.

To do so:

 - Given a distributed Guice James server
 - Stop incoming traffic
 - Monitor the mailQueues and wait them to be empty (spool & outgoing)
 - Once empty, upgrade James server and re-enable incoming traffic.

#### Upgrade to ElasticSearch 6.3

Date: 27/05/2019

SHA-1: bbdf88e56d7a22fe92e1360ef563004f3bc0dd98

JIRA: https://issues.apache.org/jira/browse/JAMES-2766

Concerned products: (experimental) Cassandra-guice products.

In version 3.3.0 indexing for the Cassandra product was handled using ElasticSearch 2.2 released on the 31 march 2016. Some major upgrades had been included in recent ElasticSearch version.

Note that ElasticSearch APIs had been undergoing some major changes, making a smooth migration hard to provide. We proposed 2 migration strategies. A
simple one leading to major search inconsistencies in the process, and another one mitigating these inconsistencies (but getting rid of them).

#### Configuration changes

ElasticSearch 6 driver is relying on the high-level REST client and no more on the internal transport protocol.

Thus, you need to update your configuration files accordingly:

In `elasticsearch.properties` modify the `elasticsearch.port` properties to reference the HTTP port of your ElasticSearch 
nodes (**9200** by default instead of the previous default value of **9300**).

##### Simple strategy

Procedure:
 - From a running James 3.3.0 cluster connected to a running ElacticSearch 2.2 cluster
 - Start an empty ElasticSearch 6.3 cluster
 - Shutdown James 3.3.0 cluster and start a James 3.4.0 cluster connected to ElasticSearch 6.3
 - Search result will then be empty and thus innacurate
 - Thus trigger a [Full ReIndexing](https://james.apache.org/server/manage-webadmin.html#ReIndexing_all_mails) to restore search consistency.

Keep in mind that full reIndexing needs to process all users email and thus can be slow.

Obviously this approach trades search consistency against ease of migration.

If search consistency during the migration is important for you, consider the next approach

##### Strategy for minimizing search inconsistency during the migration

Procedure:
 - From a running James 3.3.0 cluster connected to a running ElacticSearch 2.2 cluster
 - Start an empty ElasticSearch 6.3 cluster
 - Start a James 3.4.0 cluster connected to ElasticSearch 6.3 cluster as well as the Cassandra source of trust database. Traffic should be directed to the James 3.3.0 cluster.
 - Trigger an offline [Full ReIndexing](https://james.apache.org/server/manage-webadmin.html#ReIndexing_all_mails) on the James 3.4.0 cluster
 - Once done, direct the traffic to the James 3.4.0 cluster, and dispose the James 3.3.0 cluster as well as the ElasticSearch 2.2 cluster
 - Search result will omit changes that took place during the switching process (starting from the reIndexing start)
 - Thus trigger a [Full ReIndexing](https://james.apache.org/server/manage-webadmin.html#ReIndexing_all_mails) to restore search consistency.

Keep in mind that full reIndexing needs to process all users email and thus can be slow.

## 3.3.0 version

Changes to apply between 3.2.0 and 3.3.0 had been reported here.

Change list:

 - [Changes to the MailboxListener API](#changes-to-the-mailboxlistener-api)
 - [Changes in WebAdmin reIndexing API](#changes-in-webadmin-reindexing-api)
 - [Rename KEY column in JAMES_MAILBOX_ANNOTATION table](#james-mailbox-annotation)
 - [Mailet API changes](#mailet-api-changes)

### Changes to the MailboxListener API

#### Persistent MailboxId for MailDir

Date: 30/11/2018

SHA-1: 7e32da51a29bee1c732b2b13708bb4b986140119

JIRA: https://issues.apache.org/jira/browse/MAILBOX-292

MailboxId are now persisted in a `james-mailboxId` file. This file is created on the fly, so no action is required for users relying on
the MailDir mailbox.

#### Registration by MailboxId

Date: 30/11/2018

SHA-1: d9bcebc7dd546bd5f11f3d9b496491e7c9042fe2

JIRA: https://issues.apache.org/jira/browse/MAILBOX-354

Only user written components performing MailboxListener registration will be affected.

The MailboxPath is mutable and thus can be changed upon mailbox rename. This leads to significantly complex code with possible inconsistency windows.

Using the mailboxId, which is immutable, solves these issues.

### Changes in WebAdmin reIndexing API

Date: 05/12/2018

SHA-1: 985b9a4a75bfa75c331cba6cbf835c043185dbdb

JIRA: https://issues.apache.org/jira/browse/JAMES-2555

We made this API introduced in James 3.2.0 a bit more REST friendly. If you developed tools using this API, you will need to update them.

For more details please refer to [the latest WebAdmin documentation](https://github.com/apache/james-project/blob/master/src/site/markdown/server/manage-webadmin.md#ReIndexing).

### Rename KEY column in JAMES_MAILBOX_ANNOTATION table

Date: 19/12/2018

SHA-1: e25967664538be18ec29f47e73e661bdf29da41f

JIRA: https://issues.apache.org/jira/projects/MAILBOX/issues/MAILBOX-356

Required: Yes

Concerned products: all JPA related products

#### Upgrade procedure

Rename `KEY` column in `JAMES_MAILBOX_ANNOTATION` table. The syntax is:

##### In MySQL
```
ALTER TABLE JAMES_MAILBOX_ANNOTATION CHANGE KEY ANNOTATION_KEY varchar(200);
```

##### In MariaDB
```
ALTER TABLE JAMES_MAILBOX_ANNOTATION CHANGE COLUMN KEY ANNOTATION_KEY varchar(200);
```

_or the syntax corresponding to your database._

### Mailet API changes
In order to allow safe serialization and strong typing `org.apache.mailet.Mail` have changed.

These methods have been deprecated and replaced:

 * `getSender()` in favor of `getMaybeSender()`
 * `getAttribute(String)` in favor of `getAttribute(AttributeName)`
 * `setAttribute(String, Serializable)` in favor of `setAttribute(Attribute)`
 * `removeAttribute(String)` in favor of `removeAttribute(AttributeName)`
 * `getAttributeNames()` in favor of `attributeNames()` and `attributesMap()`

Some plain-string `AttributeName` have also been replaced:

  * `SMTP_AUTH_USER_ATTRIBUTE_NAME` in favor of `SMTP_AUTH_USER`
  * `MAILET_ERROR_ATTRIBUTE_NAME` in favor of `MAILET_ERROR`
  * `SENT_BY_MAILET` in favor of `SENT_BY_MAILET_ATTRIBUTE`'s name, it is recommended to directly set the `Attribute`.

## 3.2.0 version

Changes to apply between 3.1.0 and 3.2.0 had been reported here.

Changelist:

 - [JMAPFiltering mailet is required for JMAP capable servers](#jmapfiltering-mailet-is-required-for-jmap-capable-servers)
 - [Cassandra 3.11.3 upgrade](#cassandra-3113-upgrade)

### Noticeable changes in Mail API: Mail::getMaybeSender

Date: 31/10/2018

SHA-1: 485406252d82c2d23a4078c76b26d6fc8973bbd7

JIRA: https://issues.apache.org/jira/browse/JAMES-2557

Required: Yes

Concerned products: User developed extensions - mailet/matcher

As part of the SMTP protocol, a mail can be sent without sender. This was represented implicitly in James by a potentially null MailAddress
(`null` or `MailAddress.nullSender()`). This means that mailet/matcher implementers needs to be aware, and handle these cases. This implicit
handling makes nullSender hard to work with, and prooved to be error prone as part of the 3.2.0 development process.

Hence we propose an alternative API returning a `MaybeSender` object, requiring the caller to explicitly handle missing sender.

`Mail::getSender` had then been deprecated. We strongly encourage our users to rely on `Mail::getMaybeSender`.

Note: thanks to java-8 default API methods, this is not a breaking change.

### JMAPFiltering mailet is required for JMAP capable servers

Date: 30/08/2018

SHA-1: 9ba6a1dd270f99735c7f9d3d4b2adb5076583c10

JIRA: https://issues.apache.org/jira/browse/JAMES-2529

Required: Yes

Concerned products: Cassandra Guice products

This mailet allow users filtering rules to be applied for incoming emails.

#### Upgrade procedure

Add this line before the `LocalDelivery` mailet of your `transport` processor:

```
<mailet match="RecipientIsLocal" class="org.apache.james.jmap.mailet.filter.JMAPFiltering"/>
```

### Cassandra 3.11.3 upgrade

Date: 03/08/2018

SHA-1: de0fa8a3df69f50cbc0684dfb1b911ad497856d7

JIRA: https://issues.apache.org/jira/browse/JAMES-2514

Required: Yes

Concerned products: Cassandra Guice products

James Cassandra Guice now officially uses Cassandra 3.11.3 as a storage backend. After performing the upgrade, the team
did perform some breaking changes, detailed below. James Cassandra Guice products are no more tested against Cassandra 2.2.x. Thus we strongly
advise our users to upgrade.

#### Changes not compatible with Cassandra 2.2.x

Replace in default compaction strategies "DateTieredCompactionStrategy" by "TimeWindowCompactionStrategy".

This means you can no more start James on top of an empty Cassandra 2.2.x cluster, but existing deployments should not be impacted.

#### Upgrade procedure

We will assume that Cassandra had been installed with a debian package. Upgrade procedure stays similar in other cases.


1. Update Cassandra dists in `/etc/apt/sources.list.d/cassandra.list` to match 311x repository

```
deb http://downloads.apache.org/cassandra/debian 311x main
```


2. Update Cassandra

```
$ apt-get update
$ apt-get install cassandra=3.11.3
```

3. Correct the configuration

Edit /etc/cassandra/cassandra.yaml and ensure to really specify the interface cassandra is listening on as seeds.

4. ReStart Cassandra

4.1. Drain data & stop

```
$ nodetool drain
$ nodetool stop
```

4.2. start Cassandra

5. Upgrade SSTable (live update, performance degradation to expect)

```
$ nodetool upgradesstables apache_james
```
