/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.dlp.eventsourcing.commands;

import java.util.List;

import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.javaapi.CommandHandlerJava;

public class StoreCommandHandler implements CommandHandlerJava<StoreCommand> {

    private final EventStore eventStore;

    public StoreCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    @Override
    public Class<StoreCommand> handledClass() {
        return StoreCommand.class;
    }

    @Override
    public List<? extends Event> handleJava(StoreCommand storeCommand) {
        DLPAggregateId aggregateId = new DLPAggregateId(storeCommand.getDomain());

        return DLPDomainConfiguration.load(
                aggregateId,
                eventStore.getEventsOfAggregate(aggregateId))
            .store(storeCommand.getRules());
    }
}
