/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mailbox.events;

import java.util.Objects;
import java.util.UUID;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public class EventBusId {
    public static EventBusId of(UUID uuid) {
        return new EventBusId(uuid);
    }

    public static EventBusId random() {
        return new EventBusId(UUID.randomUUID());
    }

    public static EventBusId of(String serialized) {
        return new EventBusId(UUID.fromString(serialized));
    }

    private final UUID id;

    private EventBusId(UUID id) {
        Preconditions.checkNotNull(id);
        this.id = id;
    }

    @Override
    public final boolean equals(Object o) {
        if (o instanceof EventBusId) {
            EventBusId eventBusId = (EventBusId) o;
            return Objects.equals(this.id, eventBusId.id);
        }
        return false;
    }

    public String asString() {
        return id.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("id", id)
            .toString();
    }
}
