/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.file;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.repository.file.FilePersistentObjectRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Singleton
public class UsersFileRepository
extends AbstractJamesUsersRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersFileRepository.class);
    private FilePersistentObjectRepository objectRepository;
    private String destination;
    private FileSystem fileSystem;

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.destination = configuration.getString("destination.[@URL]");
        String urlSeparator = "/";
        if (!this.destination.endsWith(urlSeparator)) {
            this.destination = this.destination + urlSeparator;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            BaseHierarchicalConfiguration objectConfiguration = new BaseHierarchicalConfiguration();
            objectConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            this.objectRepository = new FilePersistentObjectRepository();
            this.objectRepository.setFileSystem(this.fileSystem);
            this.objectRepository.configure((HierarchicalConfiguration)objectConfiguration);
            this.objectRepository.init();
            LOGGER.debug("{} created in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.destination);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize repository", (Throwable)e);
            throw e;
        }
    }

    public Iterator<String> list() {
        return this.objectRepository.list();
    }

    protected void doAddUser(User user) throws UsersRepositoryException {
        if (this.contains(user.getUserName())) {
            throw new UsersRepositoryException(user.getUserName() + " already exists.");
        }
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Exception caught while storing user", (Throwable)e);
        }
    }

    public synchronized User getUserByName(String name) throws UsersRepositoryException {
        if (this.ignoreCase && (name = this.getRealName(name)) == null) {
            return null;
        }
        if (this.contains(name)) {
            try {
                return (User)this.objectRepository.get(name);
            }
            catch (Exception e) {
                throw new UsersRepositoryException("Exception while retrieving user", (Throwable)e);
            }
        }
        return null;
    }

    private String getRealName(String name, boolean ignoreCase) {
        if (ignoreCase) {
            Iterator<String> it = this.list();
            while (it.hasNext()) {
                String temp = it.next();
                if (!name.equalsIgnoreCase(temp)) continue;
                return temp;
            }
            return null;
        }
        return this.objectRepository.containsKey(name) ? name : null;
    }

    private String getRealName(String name) throws UsersRepositoryException {
        return this.getRealName(name, this.ignoreCase);
    }

    protected void doUpdateUser(User user) throws UsersRepositoryException {
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Exception caught while storing user", (Throwable)e);
        }
    }

    public synchronized void removeUser(String name) throws UsersRepositoryException {
        if (!this.objectRepository.remove(name)) {
            throw new UsersRepositoryException("User " + name + " does not exist");
        }
    }

    public boolean contains(String name) throws UsersRepositoryException {
        if (this.ignoreCase) {
            return this.containsCaseInsensitive(name);
        }
        return this.objectRepository.containsKey(name);
    }

    @Deprecated
    private boolean containsCaseInsensitive(String name) {
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user;
        try {
            user = this.getUserByName(name);
            if (user == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception retrieving User", e);
        }
        return user.verifyPassword(password);
    }

    public int countUsers() throws UsersRepositoryException {
        int count = 0;
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }
}

