/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.Inet6Util;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.GenericMechanism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMechanism
extends GenericMechanism
implements SPFCheckerDNSResponseListener {
    private static final String ATTRIBUTE_AMECHANISM_IPV4CHECK = "AMechanism.ipv4check";
    public static final String REGEX = "[aA](?:\\:((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-))))?(?:(?:/(\\d+))?(?://(\\d+))?)?";
    private int ip4cidr;
    private int ip6cidr;
    private SPFChecker expandedChecker = new ExpandedChecker();

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        spfData.increaseCurrentDepth();
        spfData.pushChecker(this.expandedChecker);
        return this.macroExpand.checkExpand(this.getDomain(), spfData, false);
    }

    @Override
    public synchronized void config(Configuration params) throws PermErrorException {
        super.config(params);
        if (params.groupCount() >= 2 && params.group(2) != null) {
            this.ip4cidr = Integer.parseInt(params.group(2));
            if (this.ip4cidr > 32) {
                throw new PermErrorException("Ivalid IP4 CIDR length");
            }
        } else {
            this.ip4cidr = 32;
        }
        if (params.groupCount() >= 3 && params.group(3) != null) {
            this.ip6cidr = Integer.parseInt(params.group(3).toString());
            if (this.ip6cidr > 128) {
                throw new PermErrorException("Ivalid IP6 CIDR length");
            }
        } else {
            this.ip6cidr = 128;
        }
    }

    public boolean checkAddressList(IPAddr checkAddress, List<String> addressList, int cidr) throws PermErrorException {
        for (int i = 0; i < addressList.size(); ++i) {
            String ip = addressList.get(i);
            if (ip == null) continue;
            IPAddr ipAddr = IPAddr.getAddress(ip, checkAddress.getMaskLength());
            if (!checkAddress.getMaskedIPAddress().equals(ipAddr.getMaskedIPAddress())) continue;
            return true;
        }
        return false;
    }

    protected synchronized int getIp4cidr() {
        return this.ip4cidr;
    }

    protected synchronized int getIp6cidr() {
        return this.ip6cidr;
    }

    public String toString() {
        return this.toString("a");
    }

    protected String toString(String mechKey) {
        StringBuffer res = new StringBuffer();
        res.append(mechKey);
        if (this.getDomain() != null) {
            res.append(":" + this.getDomain());
        }
        if (this.getIp4cidr() != 32) {
            res.append("/" + this.getIp4cidr());
        }
        if (this.getIp6cidr() != 128) {
            res.append("//" + this.getIp4cidr());
        }
        return res.toString();
    }

    public List<String> getAAAARecords(String strServer) {
        ArrayList<String> listAAAAData = null;
        if (IPAddr.isIPV6(strServer)) {
            listAAAAData = new ArrayList<String>();
            listAAAAData.add(strServer);
        }
        return listAAAAData;
    }

    public List<String> getARecords(String strServer) {
        ArrayList<String> listAData = null;
        if (IPAddr.isIPAddr(strServer)) {
            listAData = new ArrayList<String>();
            listAData.add(strServer);
        }
        return listAData;
    }

    @Override
    public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession spfSession) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        List<String> listAData = null;
        try {
            listAData = response.getResponse();
        }
        catch (TimeoutException e) {
            throw new TempErrorException("Timeout querying dns server");
        }
        if (listAData == null) {
            spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
            return null;
        }
        Boolean ipv4check = (Boolean)spfSession.getAttribute(ATTRIBUTE_AMECHANISM_IPV4CHECK);
        if (ipv4check.booleanValue()) {
            IPAddr checkAddress = IPAddr.getAddress(spfSession.getIpAddress(), this.getIp4cidr());
            if (this.checkAddressList(checkAddress, listAData, this.getIp4cidr())) {
                spfSession.setAttribute("Mechanism.result", Boolean.TRUE);
                return null;
            }
        } else {
            IPAddr checkAddress = IPAddr.getAddress(spfSession.getIpAddress(), this.getIp6cidr());
            if (this.checkAddressList(checkAddress, listAData, this.getIp6cidr())) {
                spfSession.setAttribute("Mechanism.result", Boolean.TRUE);
                return null;
            }
        }
        spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
        return null;
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            String host = AMechanism.this.expandHost(spfData);
            try {
                boolean validIPV4Address = Inet6Util.isValidIPV4Address(spfData.getIpAddress());
                spfData.setAttribute(AMechanism.ATTRIBUTE_AMECHANISM_IPV4CHECK, validIPV4Address);
                if (validIPV4Address) {
                    List<String> aRecords = AMechanism.this.getARecords(host);
                    if (aRecords == null) {
                        try {
                            DNSRequest request = new DNSRequest(host, 1);
                            return new DNSLookupContinuation(request, AMechanism.this);
                        }
                        catch (NoneException e) {
                            return AMechanism.this.onDNSResponse(new DNSResponse(aRecords), spfData);
                        }
                    }
                    return AMechanism.this.onDNSResponse(new DNSResponse(aRecords), spfData);
                }
                List<String> aaaaRecords = AMechanism.this.getAAAARecords(host);
                if (aaaaRecords == null) {
                    try {
                        DNSRequest request = new DNSRequest(host, 2);
                        return new DNSLookupContinuation(request, AMechanism.this);
                    }
                    catch (NoneException e) {
                        return AMechanism.this.onDNSResponse(new DNSResponse(aaaaRecords), spfData);
                    }
                }
                return AMechanism.this.onDNSResponse(new DNSResponse(aaaaRecords), spfData);
            }
            catch (Exception e) {
                AMechanism.this.log.debug("No valid ipAddress: ", e);
                throw new PermErrorException("No valid ipAddress: " + spfData.getIpAddress());
            }
        }
    }
}

