/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing;

import com.github.steveash.guavate.Guavate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.EventBus;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;

public class CommandDispatcher {
    private static final int MAX_RETRY = 10;
    private final EventBus eventBus;
    private final Map<Class, CommandHandler> handlers;

    @Inject
    public CommandDispatcher(EventBus eventBus, Set<CommandHandler<?>> handlers) {
        this.eventBus = eventBus;
        this.handlers = (Map)handlers.stream().collect(Guavate.toImmutableMap(CommandHandler::handledClass, handler -> handler));
    }

    public void dispatch(Command c) {
        this.trySeveralTimes(() -> this.tryDispatch(c)).orElseThrow(() -> new TooManyRetries(c, 10));
    }

    private Optional<Integer> trySeveralTimes(Supplier<Boolean> singleTry) {
        return IntStream.range(0, 10).boxed().filter(any -> (Boolean)singleTry.get()).findFirst();
    }

    private boolean tryDispatch(Command c) {
        try {
            List events = Optional.ofNullable(this.handlers.get(c.getClass())).map(f -> f.handle(c)).orElseThrow(() -> new UnknownCommandException(c));
            this.eventBus.publish(events);
            return true;
        }
        catch (EventStoreFailedException e) {
            return false;
        }
    }

    public static class TooManyRetries
    extends RuntimeException {
        private final Command command;
        private final int retries;

        public TooManyRetries(Command command, int retries) {
            super(String.format("Too much retries for command %s. Store failure after %d retries", command, retries));
            this.command = command;
            this.retries = retries;
        }

        public Command getCommand() {
            return this.command;
        }

        public int getRetries() {
            return this.retries;
        }
    }

    public static class UnknownCommandException
    extends RuntimeException {
        private final Command command;

        public UnknownCommandException(Command command) {
            super(String.format("Unknown command %s", command));
            this.command = command;
        }

        public Command getCommand() {
            return this.command;
        }
    }
}

