/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class MailboxAdapter
implements Mailbox {
    private static final MessageResult.FetchGroup FULL_GROUP = new POP3FetchGroup(){

        public int content() {
            return 1280;
        }
    };
    private static final MessageResult.FetchGroup BODY_GROUP = new POP3FetchGroup(){

        public int content() {
            return 1024;
        }
    };
    private static final MessageResult.FetchGroup HEADERS_GROUP = new POP3FetchGroup(){

        public int content() {
            return 256;
        }
    };
    private static final MessageResult.FetchGroup METADATA_GROUP = new POP3FetchGroup(){

        public int content() {
            return 0;
        }
    };
    private final MessageManager manager;
    private final MailboxSession session;
    private final MailboxManager mailboxManager;

    public MailboxAdapter(MailboxManager mailboxManager, MessageManager manager, MailboxSession session) {
        this.manager = manager;
        this.session = session;
        this.mailboxManager = mailboxManager;
    }

    public InputStream getMessageBody(String uid) throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            MessageResultIterator results = this.manager.getMessages(MessageUid.of((long)Long.valueOf(uid)).toRange(), BODY_GROUP, this.session);
            if (results.hasNext()) {
                InputStream inputStream = ((MessageResult)results.next()).getBody().getInputStream();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve message body for uid " + uid, e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public InputStream getMessageHeaders(String uid) throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            MessageResultIterator results = this.manager.getMessages(MessageUid.of((long)Long.valueOf(uid)).toRange(), HEADERS_GROUP, this.session);
            if (results.hasNext()) {
                InputStream inputStream = ((MessageResult)results.next()).getHeaders().getInputStream();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve message header for uid " + uid, e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public InputStream getMessage(String uid) throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            MessageResultIterator results = this.manager.getMessages(MessageUid.of((long)Long.valueOf(uid)).toRange(), FULL_GROUP, this.session);
            if (results.hasNext()) {
                InputStream inputStream = ((MessageResult)results.next()).getFullContent().getInputStream();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve message for uid " + uid, e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public List<MessageMetaData> getMessages() throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            MessageResultIterator results = this.manager.getMessages(MessageRange.all(), METADATA_GROUP, this.session);
            ArrayList<MessageMetaData> mList = new ArrayList<MessageMetaData>();
            while (results.hasNext()) {
                MessageResult result = (MessageResult)results.next();
                MessageMetaData metaData = new MessageMetaData(String.valueOf(result.getUid().asLong()), result.getSize());
                mList.add(metaData);
            }
            ImmutableList immutableList = ImmutableList.copyOf(mList);
            return immutableList;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve messages", e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public void remove(String ... uids) throws IOException {
        List uidList = (List)Arrays.stream(uids).map(uid -> MessageUid.of((long)Long.valueOf(uid))).collect(Guavate.toImmutableList());
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            this.manager.delete(uidList, this.session);
        }
        catch (MailboxException e) {
            String serializedUids = uidList.stream().map(uid -> uid.toString()).collect(Collectors.joining(",", "[", "]"));
            throw new IOException("Unable to remove messages: " + serializedUids, e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public String getIdentifier() throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            long validity = this.manager.getMetaData(false, this.session, MessageManager.MetaData.FetchGroup.NO_COUNT).getUidValidity();
            String string = Long.toString(validity);
            return string;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve indentifier for mailbox", e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public void close() throws IOException {
        try {
            this.mailboxManager.logout(this.session, true);
        }
        catch (MailboxException e) {
            throw new IOException("Unable to close mailbox", e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    private static abstract class POP3FetchGroup
    implements MessageResult.FetchGroup {
        private POP3FetchGroup() {
        }

        public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
            return new HashSet<MessageResult.FetchGroup.PartContentDescriptor>();
        }
    }
}

