/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.netty.AbstractAsyncServer;
import org.apache.james.protocols.netty.AbstractSSLAwareChannelPipelineFactory;
import org.apache.james.protocols.netty.BasicChannelUpstreamHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.LineDelimiterBasedChannelHandlerFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.HashedWheelTimer;

public class NettyServer
extends AbstractAsyncServer {
    protected final Encryption secure;
    protected final Protocol protocol;
    private final ChannelHandlerFactory frameHandlerFactory;
    private final HashedWheelTimer hashedWheelTimer;
    private ExecutionHandler eHandler;
    private ChannelUpstreamHandler coreHandler;
    private int maxCurConnections;
    private int maxCurConnectionsPerIP;

    private NettyServer(Protocol protocol, Encryption secure, ChannelHandlerFactory frameHandlerFactory, HashedWheelTimer hashedWheelTimer) {
        this.protocol = protocol;
        this.secure = secure;
        this.frameHandlerFactory = frameHandlerFactory;
        this.hashedWheelTimer = hashedWheelTimer;
    }

    protected ExecutionHandler createExecutionHandler(int size) {
        return new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(size, 0L, 0L));
    }

    public void setUseExecutionHandler(boolean useHandler, int size) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        if (useHandler) {
            this.eHandler = this.createExecutionHandler(size);
        } else {
            if (this.eHandler != null) {
                this.eHandler.releaseExternalResources();
            }
            this.eHandler = null;
        }
    }

    public void setMaxConcurrentConnections(int maxCurConnections) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnections = maxCurConnections;
    }

    public void setMaxConcurrentConnectionsPerIP(int maxCurConnectionsPerIP) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnectionsPerIP = maxCurConnectionsPerIP;
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new BasicChannelUpstreamHandler(this.protocol, this.secure);
    }

    @Override
    public synchronized void bind() throws Exception {
        this.coreHandler = this.createCoreHandler();
        super.bind();
    }

    private ChannelHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    @Override
    protected ChannelPipelineFactory createPipelineFactory(ChannelGroup group) {
        return new AbstractSSLAwareChannelPipelineFactory(this.getTimeout(), this.maxCurConnections, this.maxCurConnectionsPerIP, group, this.eHandler, this.getFrameHandlerFactory(), this.hashedWheelTimer){

            @Override
            protected ChannelUpstreamHandler createHandler() {
                return NettyServer.this.coreHandler;
            }

            @Override
            protected boolean isSSLSocket() {
                return this.getSSLContext() != null && NettyServer.this.secure != null && !NettyServer.this.secure.isStartTLS();
            }

            @Override
            protected SSLContext getSSLContext() {
                if (NettyServer.this.secure != null) {
                    return NettyServer.this.secure.getContext();
                }
                return null;
            }
        };
    }

    public static class Factory {
        private final HashedWheelTimer hashedWheelTimer;
        private Protocol protocol;
        private Optional<Encryption> secure;
        private Optional<ChannelHandlerFactory> frameHandlerFactory;

        @Inject
        public Factory(HashedWheelTimer hashedWheelTimer) {
            this.hashedWheelTimer = hashedWheelTimer;
            this.secure = Optional.empty();
            this.frameHandlerFactory = Optional.empty();
        }

        public Factory protocol(Protocol protocol) {
            Preconditions.checkNotNull((Object)protocol, (Object)"'protocol' is mandatory");
            this.protocol = protocol;
            return this;
        }

        public Factory secure(Encryption secure) {
            this.secure = Optional.ofNullable(secure);
            return this;
        }

        public Factory frameHandlerFactory(ChannelHandlerFactory frameHandlerFactory) {
            this.frameHandlerFactory = Optional.ofNullable(frameHandlerFactory);
            return this;
        }

        public NettyServer build() {
            Preconditions.checkState((this.protocol != null ? 1 : 0) != 0, (Object)"'protocol' is mandatory");
            return new NettyServer(this.protocol, this.secure.orElse(null), this.frameHandlerFactory.orElse(new LineDelimiterBasedChannelHandlerFactory(8192)), this.hashedWheelTimer);
        }
    }
}

