/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import org.apache.james.protocols.netty.ChannelGroupHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.apache.james.protocols.netty.LineDelimiterBasedChannelHandlerFactory;
import org.apache.james.protocols.netty.TimeoutHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public abstract class AbstractChannelPipelineFactory
implements ChannelPipelineFactory {
    public static final int MAX_LINE_LENGTH = 8192;
    protected final ConnectionLimitUpstreamHandler connectionLimitHandler;
    protected final ConnectionPerIpLimitUpstreamHandler connectionPerIpLimitHandler;
    private final HashedWheelTimer timer;
    private final ChannelGroupHandler groupHandler;
    private final int timeout;
    private final ExecutionHandler eHandler;
    private final ChannelHandlerFactory frameHandlerFactory;

    public AbstractChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup channels, HashedWheelTimer hashedWheelTimer) {
        this(timeout, maxConnections, maxConnectsPerIp, channels, null, new LineDelimiterBasedChannelHandlerFactory(8192), hashedWheelTimer);
    }

    public AbstractChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup channels, ExecutionHandler eHandler, ChannelHandlerFactory frameHandlerFactory, HashedWheelTimer hashedWheelTimer) {
        this.connectionLimitHandler = new ConnectionLimitUpstreamHandler(maxConnections);
        this.connectionPerIpLimitHandler = new ConnectionPerIpLimitUpstreamHandler(maxConnectsPerIp);
        this.groupHandler = new ChannelGroupHandler(channels);
        this.timeout = timeout;
        this.eHandler = eHandler;
        this.frameHandlerFactory = frameHandlerFactory;
        this.timer = hashedWheelTimer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
        pipeline.addLast(" connectionLimit", (ChannelHandler)this.connectionLimitHandler);
        pipeline.addLast("connectionPerIpLimit", (ChannelHandler)this.connectionPerIpLimitHandler);
        pipeline.addLast("framer", this.frameHandlerFactory.create(pipeline));
        pipeline.addLast("chunkHandler", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("timeoutHandler", (ChannelHandler)new TimeoutHandler((Timer)this.timer, this.timeout));
        if (this.eHandler != null) {
            pipeline.addLast("executionHandler", (ChannelHandler)this.eHandler);
        }
        pipeline.addLast("coreHandler", (ChannelHandler)this.createHandler());
        return pipeline;
    }

    protected abstract ChannelUpstreamHandler createHandler();
}

