/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailetUtil;
import org.apache.mailet.base.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericMailet
implements Mailet,
MailetConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericMailet.class);
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private MailetConfig config = null;

    public void destroy() {
    }

    public boolean getInitParameter(String name, boolean defaultValue) {
        if (this.config == null) {
            throw new NullPointerException("Mailet configuration must be set before getInitParameter is called.");
        }
        return MailetUtil.getInitParameter(this.config, name).orElse(defaultValue);
    }

    public Optional<String> getInitParameterAsOptional(String name) {
        String value = this.getInitParameter(name);
        if (Strings.isNullOrEmpty((String)value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public boolean getBooleanParameter(String value, boolean defaultValue) {
        if (defaultValue) {
            return !GenericMailet.isFalseOrNo(value);
        }
        return GenericMailet.isTrueOrYes(value);
    }

    private static boolean isFalseOrNo(String value) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)FALSE) || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)NO);
    }

    private static boolean isTrueOrYes(String value) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)TRUE) || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)YES);
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public String getInitParameter(String name, String defValue) {
        String res = this.config.getInitParameter(name);
        if (res == null) {
            return defValue;
        }
        return res;
    }

    public Iterator<String> getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public MailetConfig getMailetConfig() {
        return this.config;
    }

    public MailetContext getMailetContext() {
        return this.getMailetConfig().getMailetContext();
    }

    public String getMailetInfo() {
        return "";
    }

    public String getMailetName() {
        return this.config.getMailetName();
    }

    public void init(MailetConfig newConfig) throws MessagingException {
        this.config = newConfig;
        this.init();
    }

    public void init() throws MessagingException {
    }

    @Deprecated
    public void log(String message) {
        LOGGER.info(message);
    }

    @Deprecated
    public void log(String message, Throwable t) {
        LOGGER.error(message, t);
    }

    public abstract void service(Mail var1) throws MessagingException;

    protected final void checkInitParameters(String[] allowedArray) throws MessagingException {
        if (allowedArray == null) {
            return;
        }
        HashSet allowed = new HashSet();
        ArrayList<String> bad = new ArrayList<String>();
        Collections.addAll(allowed, allowedArray);
        Iterator<String> iterator = this.getInitParameterNames();
        while (iterator.hasNext()) {
            String parameter = iterator.next();
            if (allowed.contains(parameter)) continue;
            bad.add(parameter);
        }
        if (bad.size() > 0) {
            throw new MessagingException("Unexpected init parameters found: " + StringUtils.arrayToString(bad.toArray()));
        }
    }
}

