/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;

public class JsonGenericSerializer<T, U extends DTO> {
    private final Map<Class<? extends T>, DTOModule<T, U>> domainClassToModule;
    private final Map<String, DTOModule<T, U>> typeToModule;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @SafeVarargs
    public static <T, U extends DTO> JsonGenericSerializer<T, U> of(DTOModule<T, U> ... modules) {
        return new JsonGenericSerializer<T, U>(ImmutableSet.copyOf((Object[])modules));
    }

    public JsonGenericSerializer(Set<DTOModule<T, U>> modules) {
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new GuavaModule());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        this.objectMapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        this.typeToModule = (Map)modules.stream().collect(Guavate.toImmutableMap(DTOModule::getDomainObjectType, Function.identity()));
        this.domainClassToModule = (Map)modules.stream().collect(Guavate.toImmutableMap(DTOModule::getDomainObjectClass, Function.identity()));
    }

    public String serialize(T domainObject) throws JsonProcessingException {
        U dto = Optional.ofNullable(this.domainClassToModule.get(domainObject.getClass())).orElseThrow(() -> new UnknownTypeException("unknown type " + domainObject.getClass())).toDTO(domainObject);
        return this.objectMapper.writeValueAsString(dto);
    }

    public T deserialize(String value) throws IOException {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(value);
            JsonNode typeNode = jsonNode.path("type");
            if (typeNode.isMissingNode()) {
                throw new InvalidTypeException("No \"type\" property found in the json document");
            }
            DTOModule<T, U> dtoModule = this.retrieveModuleForType(typeNode.asText());
            DTO dto = (DTO)this.objectMapper.readValue(this.objectMapper.treeAsTokens((TreeNode)jsonNode), dtoModule.getDTOClass());
            return dtoModule.getToDomainObjectConverter().convert(dto);
        }
        catch (MismatchedInputException e) {
            throw new InvalidTypeException("Unable to deserialize the json document", e);
        }
    }

    private DTOModule<T, U> retrieveModuleForType(String type) {
        return Optional.ofNullable(this.typeToModule.get(type)).orElseThrow(() -> new UnknownTypeException("unknown type " + type));
    }

    public static class UnknownTypeException
    extends RuntimeException {
        public UnknownTypeException(String message) {
            super(message);
        }
    }

    public static class InvalidTypeException
    extends RuntimeException {
        public InvalidTypeException(String message) {
            super(message);
        }

        public InvalidTypeException(String message, MismatchedInputException exception) {
            super(message, (Throwable)exception);
        }
    }
}

