/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;

public class User {
    private final String localPart;
    private final Optional<Domain> domainPart;

    public static User fromUsername(String username) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'@').split((CharSequence)username));
        switch (parts.size()) {
            case 1: {
                return User.fromLocalPartWithoutDomain(username);
            }
            case 2: {
                return User.fromLocalPartWithDomain((String)parts.get(0), (String)parts.get(1));
            }
        }
        throw new IllegalArgumentException("The username should not contain multiple domain delimiter.");
    }

    public static User fromLocalPartWithDomain(String localPart, String domain) {
        Preconditions.checkNotNull((Object)domain);
        return User.fromLocalPartWithDomain(localPart, Domain.of(domain));
    }

    public static User fromLocalPartWithDomain(String localPart, Domain domain) {
        Preconditions.checkNotNull((Object)domain);
        return new User(localPart, Optional.of(domain));
    }

    public static User fromMailAddress(MailAddress address) {
        Preconditions.checkNotNull((Object)address);
        return new User(address.getLocalPart(), Optional.of(address.getDomain()));
    }

    public static User fromLocalPartWithoutDomain(String localPart) {
        return User.from(localPart, Optional.empty());
    }

    public static User from(String localPart, Optional<String> domain) {
        return new User(localPart, domain.map(Domain::of));
    }

    private User(String localPart, Optional<Domain> domainPart) {
        Preconditions.checkNotNull((Object)localPart);
        Preconditions.checkArgument((!localPart.isEmpty() ? 1 : 0) != 0, (Object)"username should not be empty");
        Preconditions.checkArgument((!localPart.contains("@") ? 1 : 0) != 0, (Object)"username can not contain domain delimiter");
        this.localPart = localPart;
        this.domainPart = domainPart;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public Optional<Domain> getDomainPart() {
        return this.domainPart;
    }

    public boolean hasDomainPart() {
        return this.domainPart.isPresent();
    }

    public User withDefaultDomain(Optional<Domain> defaultDomain) {
        if (this.hasDomainPart()) {
            return this;
        }
        return new User(this.localPart, defaultDomain);
    }

    public User withDefaultDomain(Domain defaultDomain) {
        return this.withDefaultDomain(Optional.of(defaultDomain));
    }

    public User withDefaultDomainFromUser(User other) {
        return this.withDefaultDomain(other.domainPart);
    }

    public String asString() {
        return this.domainPart.map(domain -> this.localPart + "@" + domain.asString()).orElse(this.localPart);
    }

    public MailAddress asMailAddress() throws AddressException {
        Preconditions.checkState((boolean)this.hasDomainPart());
        return new MailAddress(this.localPart, this.domainPart.get());
    }

    public final boolean equals(Object o) {
        if (o instanceof User) {
            User user = (User)o;
            return Objects.equals(this.localPart, user.localPart) && Objects.equals(this.domainPart, user.domainPart);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.localPart, this.domainPart);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localPart", (Object)this.localPart).add("domainPart", this.domainPart).toString();
    }
}

