/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import javax.inject.Inject;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.jpa.JPAMailboxManager;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMailboxManager
extends JPAMailboxManager {
    @Inject
    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, SessionProvider sessionProvider, MessageParser messageParser, MessageId.Factory messageIdFactory, EventBus eventBus, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex index) {
        super(mapperFactory, sessionProvider, (MailboxPathLocker)new JVMMailboxPathLocker(), messageParser, messageIdFactory, eventBus, annotationManager, storeRightManager, quotaComponents, index);
    }

    protected OpenJPAMessageManager.AdvancedFeature getAdvancedFeature() {
        return OpenJPAMessageManager.AdvancedFeature.None;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) {
        return new OpenJPAMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailboxRow, this.getAdvancedFeature(), this.getQuotaComponents().getQuotaManager(), this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager());
    }
}

