/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.store.mail.AbstractLockingUidProvider;

public class JPAUidProvider
extends AbstractLockingUidProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAUidProvider(MailboxPathLocker locker, EntityManagerFactory factory) {
        super(locker);
        this.factory = factory;
    }

    public Optional<MessageUid> lastUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try (EntityManager manager = null;){
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            long uid = (Long)manager.createNamedQuery("findLastUid").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            manager.getTransaction().commit();
            if (uid == 0L) {
                Optional<MessageUid> optional = Optional.empty();
                return optional;
            }
            Optional<MessageUid> optional = Optional.of(MessageUid.of((long)uid));
            return optional;
        }
    }

    protected MessageUid lockedNextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try (EntityManager manager = null;){
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long uid = m.consumeUid();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            MessageUid messageUid = MessageUid.of((long)uid);
            return messageUid;
        }
    }
}

