/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AbstractLockingModSeqProvider;

public class JPAModSeqProvider
extends AbstractLockingModSeqProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAModSeqProvider(MailboxPathLocker locker, EntityManagerFactory factory) {
        super(locker);
        this.factory = factory;
    }

    public long highestModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try (EntityManager manager = null;){
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            long highest = (Long)manager.createNamedQuery("findHighestModSeq").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            manager.getTransaction().commit();
            long l = highest;
            return l;
        }
    }

    protected long lockedNextModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try (EntityManager manager = null;){
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long modSeq = m.consumeModSeq();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            long l = modSeq;
            return l;
        }
    }

    public long highestModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException("not implemented");
    }
}

