/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;

public class JPAMailboxMapper
extends JPATransactionalMapper
implements MailboxMapper {
    private static final char SQL_WILDCARD_CHAR = '%';
    private String lastMailboxName;

    public JPAMailboxMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    protected void commit() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().commit();
        }
        catch (PersistenceException e) {
            Throwable t;
            if (e instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            if (e instanceof RollbackException && (t = e.getCause()) != null && t instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            throw new MailboxException("Commit of transaction failed", (Throwable)e);
        }
    }

    public MailboxId save(Mailbox mailbox) throws MailboxException {
        try {
            if (this.isPathAlreadyUsedByAnotherMailbox(mailbox)) {
                throw new MailboxExistsException(mailbox.getName());
            }
            this.lastMailboxName = mailbox.getName();
            JPAMailbox persistedMailbox = this.jpaMailbox(mailbox);
            this.getEntityManager().persist((Object)persistedMailbox);
            mailbox.setMailboxId((MailboxId)persistedMailbox.getMailboxId());
            return persistedMailbox.getMailboxId();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of mailbox " + mailbox.getName() + " failed", (Throwable)e);
        }
    }

    private JPAMailbox jpaMailbox(Mailbox mailbox) {
        if (mailbox.getMailboxId() == null) {
            return JPAMailbox.from(mailbox);
        }
        try {
            JPAMailbox result = this.loadJpaMailbox(mailbox.getMailboxId());
            result.setNamespace(mailbox.getNamespace());
            result.setUser(mailbox.getUser());
            result.setName(mailbox.getName());
            return result;
        }
        catch (MailboxNotFoundException e) {
            return JPAMailbox.from(mailbox);
        }
    }

    private boolean isPathAlreadyUsedByAnotherMailbox(Mailbox mailbox) throws MailboxException {
        try {
            Mailbox storedMailbox = this.findMailboxByPath(mailbox.generateAssociatedPath());
            return !Objects.equal((Object)storedMailbox.getMailboxId(), (Object)mailbox.getMailboxId());
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public Mailbox findMailboxByPath(MailboxPath mailboxPath) throws MailboxException, MailboxNotFoundException {
        try {
            if (mailboxPath.getUser() == null) {
                return ((JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxByName", JPAMailbox.class).setParameter("nameParam", (Object)mailboxPath.getName()).setParameter("namespaceParam", (Object)mailboxPath.getNamespace()).getSingleResult()).toMailbox();
            }
            return ((JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxByNameWithUser", JPAMailbox.class).setParameter("nameParam", (Object)mailboxPath.getName()).setParameter("namespaceParam", (Object)mailboxPath.getNamespace()).setParameter("userParam", (Object)mailboxPath.getUser()).getSingleResult()).toMailbox();
        }
        catch (NoResultException e) {
            throw new MailboxNotFoundException(mailboxPath);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of mailbox " + mailboxPath + " failed", (Throwable)e);
        }
    }

    public Mailbox findMailboxById(MailboxId id) throws MailboxException, MailboxNotFoundException {
        try {
            return this.loadJpaMailbox(id).toMailbox();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of mailbox " + id.serialize() + " failed", (Throwable)e);
        }
    }

    private JPAMailbox loadJpaMailbox(MailboxId id) throws MailboxNotFoundException {
        JPAId mailboxId = (JPAId)id;
        try {
            return (JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxById", JPAMailbox.class).setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (NoResultException e) {
            throw new MailboxNotFoundException((MailboxId)mailboxId);
        }
    }

    public boolean exists(MailboxId id) throws MailboxException, MailboxNotFoundException {
        try {
            this.loadJpaMailbox(id);
            return true;
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            this.getEntityManager().createNamedQuery("deleteMessages").setParameter("idParam", (Object)mailboxId.getRawId()).executeUpdate();
            JPAMailbox jpaMailbox = (JPAMailbox)this.getEntityManager().find(JPAMailbox.class, (Object)mailboxId.getRawId());
            this.getEntityManager().remove((Object)jpaMailbox);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailbox " + mailbox + " failed", (Throwable)e);
        }
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        try {
            return (List)this.findMailboxWithPathLikeTypedQuery(path).getResultList().stream().map(JPAMailbox::toMailbox).collect(Guavate.toImmutableList());
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of mailbox " + path + " failed", (Throwable)e);
        }
    }

    private TypedQuery<JPAMailbox> findMailboxWithPathLikeTypedQuery(MailboxPath path) {
        if (path.getUser() == null) {
            return this.getEntityManager().createNamedQuery("findMailboxWithNameLike", JPAMailbox.class).setParameter("nameParam", (Object)path.getName()).setParameter("namespaceParam", (Object)path.getNamespace());
        }
        return this.getEntityManager().createNamedQuery("findMailboxWithNameLikeWithUser", JPAMailbox.class).setParameter("nameParam", (Object)path.getName()).setParameter("namespaceParam", (Object)path.getNamespace()).setParameter("userParam", (Object)path.getUser());
    }

    public void deleteAllMemberships() throws MailboxException {
        try {
            this.getEntityManager().createNamedQuery("deleteAllMemberships").executeUpdate();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Throwable)e);
        }
    }

    public void deleteAllMailboxes() throws MailboxException {
        try {
            this.getEntityManager().createNamedQuery("deleteAllMailboxes").executeUpdate();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Throwable)e);
        }
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        String name = mailbox.getName() + delimiter + '%';
        Long numberOfChildMailboxes = mailbox.getUser() == null ? (Long)this.getEntityManager().createNamedQuery("countMailboxesWithNameLike").setParameter("nameParam", (Object)name).setParameter("namespaceParam", (Object)mailbox.getNamespace()).getSingleResult() : (Long)this.getEntityManager().createNamedQuery("countMailboxesWithNameLikeWithUser").setParameter("nameParam", (Object)name).setParameter("namespaceParam", (Object)mailbox.getNamespace()).setParameter("userParam", (Object)mailbox.getUser()).getSingleResult();
        return numberOfChildMailboxes != null && numberOfChildMailboxes > 0L;
    }

    public List<Mailbox> list() throws MailboxException {
        try {
            return (List)this.getEntityManager().createNamedQuery("listMailboxes", JPAMailbox.class).getResultList().stream().map(JPAMailbox::toMailbox).collect(Guavate.toImmutableList());
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Throwable)e);
        }
    }

    public ACLDiff updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) throws MailboxException {
        MailboxACL oldACL = mailbox.getACL();
        MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
        mailbox.setACL(newACL);
        return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
    }

    public ACLDiff setACL(Mailbox mailbox, MailboxACL mailboxACL) throws MailboxException {
        MailboxACL oldMailboxAcl = mailbox.getACL();
        mailbox.setACL(mailboxACL);
        return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
    }

    public List<Mailbox> findNonPersonalMailboxes(String userName, MailboxACL.Right right) throws MailboxException {
        return ImmutableList.of();
    }
}

