/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotation;
import org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAnnotationMapper
extends JPATransactionalMapper
implements AnnotationMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPAAnnotationMapper.class);
    public static final Function<JPAMailboxAnnotation, MailboxAnnotation> READ_ROW = input -> MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey(input.getKey()), (String)input.getValue());

    public JPAAnnotationMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        JPAId jpaId = (JPAId)mailboxId;
        return (List)this.getEntityManager().createNamedQuery("retrieveAllAnnotations", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).getResultList().stream().map(READ_ROW).collect(Guavate.toImmutableList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        try {
            JPAId jpaId = (JPAId)mailboxId;
            return ImmutableList.copyOf((Iterable)Iterables.transform(keys, input -> READ_ROW.apply((JPAMailboxAnnotation)this.getEntityManager().createNamedQuery("retrieveByKey", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).setParameter("keyParam", (Object)input.asString()).getSingleResult())));
        }
        catch (NoResultException e) {
            return ImmutableList.of();
        }
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.getFilteredLikes((JPAId)mailboxId, keys, key -> annotation -> key.isParentOrIsEqual(annotation.getKey()));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.getFilteredLikes((JPAId)mailboxId, keys, key -> annotation -> key.isAncestorOrIsEqual(annotation.getKey()));
    }

    private List<MailboxAnnotation> getFilteredLikes(JPAId jpaId, Set<MailboxAnnotationKey> keys, Function<MailboxAnnotationKey, Predicate<MailboxAnnotation>> predicateFunction) {
        try {
            return (List)keys.stream().flatMap(key -> this.getEntityManager().createNamedQuery("retrieveByKeyLike", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).setParameter("keyParam", (Object)(key.asString() + '%')).getResultList().stream().map(READ_ROW).filter((Predicate)predicateFunction.apply((MailboxAnnotationKey)key))).collect(Guavate.toImmutableList());
        }
        catch (NoResultException e) {
            return ImmutableList.of();
        }
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        try {
            JPAId jpaId = (JPAId)mailboxId;
            JPAMailboxAnnotation jpaMailboxAnnotation = (JPAMailboxAnnotation)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), key.asString()));
            this.getEntityManager().remove((Object)jpaMailboxAnnotation);
        }
        catch (NoResultException e) {
            LOGGER.debug("Mailbox annotation not found for ID {} and key {}", (Object)mailboxId.serialize(), (Object)key.asString());
        }
        catch (PersistenceException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        JPAId jpaId = (JPAId)mailboxId;
        if (this.getAnnotationsByKeys(mailboxId, (Set<MailboxAnnotationKey>)ImmutableSet.of((Object)mailboxAnnotation.getKey())).isEmpty()) {
            this.getEntityManager().persist((Object)new JPAMailboxAnnotation(jpaId.getRawId(), mailboxAnnotation.getKey().asString(), mailboxAnnotation.getValue().orElse(null)));
        } else {
            ((JPAMailboxAnnotation)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), mailboxAnnotation.getKey().asString()))).setValue(mailboxAnnotation.getValue().orElse(null));
        }
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        JPAId jpaId = (JPAId)mailboxId;
        Optional<JPAMailboxAnnotation> row = Optional.ofNullable((JPAMailboxAnnotation)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), mailboxAnnotation.getKey().asString())));
        return row.isPresent();
    }

    public int countAnnotations(MailboxId mailboxId) {
        try {
            JPAId jpaId = (JPAId)mailboxId;
            return ((Long)this.getEntityManager().createNamedQuery("countAnnotationsInMailbox").setParameter("idParam", (Object)jpaId.getRawId()).getSingleResult()).intValue();
        }
        catch (PersistenceException pe) {
            throw new RuntimeException(pe);
        }
    }
}

