/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.Protocol;

public class MailRepositoryUrl {
    private static final int PROTOCOL_PART = 0;
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final int SKIP_PROTOCOL = 1;
    private final String value;
    private final MailRepositoryPath path;
    private final Protocol protocol;

    public static MailRepositoryUrl fromEncoded(String encodedUrl) throws UnsupportedEncodingException {
        return MailRepositoryUrl.from(URLDecoder.decode(encodedUrl, StandardCharsets.UTF_8.displayName()));
    }

    public static MailRepositoryUrl from(String url) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkArgument((boolean)url.contains(PROTOCOL_SEPARATOR), (Object)"The expected format is: <protocol> \"://\" <path>");
        List urlParts = Splitter.on((String)PROTOCOL_SEPARATOR).splitToList((CharSequence)url);
        Protocol protocol = new Protocol((String)urlParts.get(0));
        MailRepositoryPath path = MailRepositoryPath.from(Joiner.on((String)PROTOCOL_SEPARATOR).join(Iterables.skip((Iterable)urlParts, (int)1)));
        return new MailRepositoryUrl(path, protocol);
    }

    public static MailRepositoryUrl fromPathAndProtocol(MailRepositoryPath path, String protocol) {
        return new MailRepositoryUrl(path, new Protocol(protocol));
    }

    public static MailRepositoryUrl fromPathAndProtocol(Protocol protocol, MailRepositoryPath path) {
        return new MailRepositoryUrl(path, protocol);
    }

    private MailRepositoryUrl(MailRepositoryPath path, Protocol protocol) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)protocol);
        this.path = path;
        this.protocol = protocol;
        this.value = protocol.getValue() + PROTOCOL_SEPARATOR + path.asString();
    }

    public String asString() {
        return this.value;
    }

    public MailRepositoryPath getPath() {
        return this.path;
    }

    public MailRepositoryUrl subUrl(String suffix) {
        return new MailRepositoryUrl(this.path.subPath(suffix), this.protocol);
    }

    public String urlEncoded() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.value, StandardCharsets.UTF_8.displayName());
    }

    public boolean hasPrefix(MailRepositoryUrl other) {
        return Objects.equals(this.protocol, other.protocol) && this.path.hasPrefix(other.path);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailRepositoryUrl) {
            MailRepositoryUrl that = (MailRepositoryUrl)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

