/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class MailRepositoryProperties {
    private final boolean browsable;

    static Builder.RequireBrowsable builder() {
        return Builder.ReadyToBuild::new;
    }

    private MailRepositoryProperties(boolean browsable) {
        this.browsable = browsable;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailRepositoryProperties) {
            MailRepositoryProperties that = (MailRepositoryProperties)o;
            return Objects.equals(this.browsable, that.browsable);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.browsable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("browsable", this.browsable).toString();
    }

    static class Builder {
        Builder() {
        }

        static class ReadyToBuild {
            private final boolean browsable;

            ReadyToBuild(boolean browsable) {
                this.browsable = browsable;
            }

            MailRepositoryProperties build() {
                return new MailRepositoryProperties(this.browsable);
            }
        }

        @FunctionalInterface
        static interface RequireBrowsable {
            public ReadyToBuild browsable(boolean var1);

            default public ReadyToBuild canBrowse() {
                return this.browsable(true);
            }

            default public ReadyToBuild canNotBrowse() {
                return this.browsable(false);
            }
        }
    }
}

