/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.ValueHandler;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.meta.ValueMetaDataImpl;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;

public class ValueMappingImpl
extends ValueMetaDataImpl
implements ValueMapping {
    private static final long serialVersionUID = 6440545965133775709L;
    private static final Localizer _loc = Localizer.forPackage(ValueMappingImpl.class);
    private ValueMappingInfo _info;
    private ValueHandler _handler = null;
    private ClassMapping[] _typeArr = null;
    private Column[] _cols = Schemas.EMPTY_COLUMNS;
    private ColumnIO _io = null;
    private ForeignKey _fk = null;
    private Map<ClassMapping, ForeignKey> _targetFKs = null;
    private Index _idx = null;
    private Unique _unq = null;
    private int _join = 0;
    private boolean _criteria = false;
    private int _poly = 0;

    public ValueMappingImpl(FieldMapping owner) {
        super(owner);
        this._info = owner.getMappingRepository().newMappingInfo(this);
        this._info.setUseClassCriteria(owner.getMappingRepository().getMappingDefaults().useClassCriteria());
    }

    protected ValueMappingImpl() {
    }

    @Override
    public ValueMappingInfo getValueInfo() {
        return this._info;
    }

    @Override
    public ValueHandler getHandler() {
        return this._handler;
    }

    @Override
    public void setHandler(ValueHandler handler) {
        this._handler = handler;
    }

    @Override
    public MappingRepository getMappingRepository() {
        return (MappingRepository)this.getRepository();
    }

    @Override
    public FieldMapping getFieldMapping() {
        return (FieldMapping)this.getFieldMetaData();
    }

    @Override
    public ClassMapping getTypeMapping() {
        return (ClassMapping)this.getTypeMetaData();
    }

    @Override
    public ClassMapping getDeclaredTypeMapping() {
        return (ClassMapping)this.getDeclaredTypeMetaData();
    }

    @Override
    public ClassMapping getEmbeddedMapping() {
        return (ClassMapping)this.getEmbeddedMetaData();
    }

    @Override
    public FieldMapping getValueMappedByMapping() {
        return (FieldMapping)this.getValueMappedByMetaData();
    }

    @Override
    public Column[] getColumns() {
        if (this._cols.length != 0) {
            return this._cols;
        }
        if (this._fk != null) {
            return this._fk.getColumns();
        }
        if (this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getColumns();
        }
        return this._cols;
    }

    @Override
    public void setColumns(Column[] cols) {
        if (cols == null) {
            cols = Schemas.EMPTY_COLUMNS;
        }
        this._cols = cols;
    }

    @Override
    public ColumnIO getColumnIO() {
        if (this._cols.length == 0 && this._fk == null && this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getColumnIO();
        }
        return this._io == null ? ColumnIO.UNRESTRICTED : this._io;
    }

    @Override
    public void setColumnIO(ColumnIO io) {
        this._io = io;
    }

    @Override
    public ForeignKey getForeignKey() {
        if (this._fk == null && this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getForeignKey();
        }
        return this._fk;
    }

    @Override
    public void setForeignKey(ForeignKey fk) {
        this._fk = fk;
        if (fk == null) {
            this._join = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignKey getForeignKey(ClassMapping target, int targetNumber) {
        if (this._fk == null && this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getForeignKey(target);
        }
        if (target == null) {
            return this._fk;
        }
        ClassMapping embeddedMeta = (ClassMapping)this.getEmbeddedMetaData();
        if (embeddedMeta != null) {
            FieldMapping[] fields = embeddedMeta.getFieldMappings();
            int j = 0;
            for (int i = 0; i < fields.length; ++i) {
                ValueMapping val = fields[i].getValueMapping();
                if (val.getDeclaredTypeMapping() != target) continue;
                if (targetNumber == j) {
                    return val.getForeignKey();
                }
                ++j;
            }
        }
        if (this._fk == null && this._cols.length == 0) {
            return null;
        }
        for (ClassMapping sup = target; sup != null; sup = sup.getJoinablePCSuperclassMapping()) {
            if (sup == this.getTypeMetaData()) {
                return this._fk;
            }
            target = sup;
        }
        ValueMappingImpl valueMappingImpl = this;
        synchronized (valueMappingImpl) {
            if (this._targetFKs != null) {
                ForeignKey cachedFK = this._targetFKs.get(target);
                if (cachedFK != null) {
                    return cachedFK;
                }
            } else {
                this._targetFKs = new HashMap<ClassMapping, ForeignKey>();
            }
            ForeignKey newfk = this._join == 0 ? this.newForwardForeignKey(target) : this.newInverseForeignKey(target);
            this._targetFKs.put(target, newfk);
            return newfk;
        }
    }

    @Override
    public ForeignKey getForeignKey(ClassMapping target) {
        return this.getForeignKey(target, 0);
    }

    private ForeignKey newForwardForeignKey(ClassMapping target) {
        Column[] cols;
        Table table;
        if (this._fk == null) {
            table = this._cols[0].getTable();
            cols = this._cols;
        } else {
            table = this._fk.getTable();
            cols = this._fk.getColumns();
        }
        Column[] tcols = new Column[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            tcols[i] = cols[i].getTargetField() != null ? this.getEquivalentColumn(cols[i], target, cols[i].getTargetField()) : (this._fk != null ? this.getEquivalentColumn(this._fk.getPrimaryKeyColumn(cols[i]).getIdentifier(), target, true) : (!DBIdentifier.isNull(cols[i].getTargetIdentifier()) ? this.getEquivalentColumn(cols[i].getTargetIdentifier(), target, true) : this.getEquivalentColumn(cols[i].getIdentifier(), target, false)));
        }
        ForeignKey newfk = table.addForeignKey();
        newfk.setJoins(cols, tcols);
        if (this._fk != null) {
            int i;
            cols = this._fk.getConstantColumns();
            for (i = 0; i < cols.length; ++i) {
                newfk.joinConstant(cols[i], this._fk.getConstant(cols[i]));
            }
            cols = this._fk.getConstantPrimaryKeyColumns();
            for (i = 0; i < cols.length; ++i) {
                newfk.joinConstant(this._fk.getPrimaryKeyConstant(cols[i]), this.getEquivalentColumn(cols[i].getIdentifier(), target, true));
            }
        }
        return newfk;
    }

    private Column getEquivalentColumn(Column col, ClassMapping target, String fieldName) {
        FieldMapping field = target.getFieldMapping(fieldName = fieldName.substring(fieldName.indexOf(46) + 1));
        if (field == null) {
            throw new MetaDataException(_loc.get("no-equiv-field", new Object[]{this, target, fieldName, col}));
        }
        Column[] cols = field.getColumns();
        if (cols.length != 1) {
            throw new MetaDataException(_loc.get("bad-equiv-field", new Object[]{this, target, fieldName, col}));
        }
        return cols[0];
    }

    private Column getEquivalentColumn(DBIdentifier colName, ClassMapping target, boolean explicit) {
        if (!explicit) {
            for (ClassMapping cls = target; cls != null; cls = cls.getJoinablePCSuperclassMapping()) {
                if (cls.getTable() == null) continue;
                if (cls.getPrimaryKeyColumns().length != 1) break;
                return cls.getPrimaryKeyColumns()[0];
            }
        }
        for (ClassMapping cls = target; cls != null; cls = cls.getJoinablePCSuperclassMapping()) {
            Column ret;
            if (cls.getTable() == null || (ret = cls.getTable().getColumn(colName)) == null) continue;
            return ret;
        }
        throw new MetaDataException(_loc.get("no-equiv-col", this, target, colName));
    }

    private ForeignKey newInverseForeignKey(ClassMapping target) {
        FieldMapping field = this.getFieldMapping();
        FieldMapping mapped = field.getMappedByMapping();
        if (mapped == null) {
            throw new MetaDataException(_loc.get("cant-inverse", this));
        }
        if ((mapped = target.getFieldMapping(mapped.getIndex())) == null || mapped.getTypeCode() != 15) {
            throw new MetaDataException(_loc.get("no-equiv-mapped-by", this, target, field.getMappedBy()));
        }
        return mapped.getForeignKey();
    }

    @Override
    public int getJoinDirection() {
        if (this._fk == null && this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getJoinDirection();
        }
        return this._join;
    }

    @Override
    public void setJoinDirection(int direction) {
        this._join = direction;
    }

    @Override
    public void setForeignKey(Row row, OpenJPAStateManager rel, int targetNumber) throws SQLException {
        if (rel != null) {
            row.setForeignKey(this.getForeignKey((ClassMapping)rel.getMetaData(), targetNumber), this._io, rel);
        } else if (this._fk != null) {
            row.setForeignKey(this._fk, this._io, null);
        } else {
            for (int i = 0; i < this._cols.length; ++i) {
                if (this._io != null && (row.getAction() != 1 || !this._io.isInsertable(i, true)) && (row.getAction() == 1 || !this._io.isUpdatable(i, true))) continue;
                row.setNull(this._cols[i]);
            }
        }
    }

    @Override
    public void setForeignKey(Row row, OpenJPAStateManager rel) throws SQLException {
        this.setForeignKey(row, rel, 0);
    }

    @Override
    public void whereForeignKey(Row row, OpenJPAStateManager rel) throws SQLException {
        if (rel != null) {
            row.whereForeignKey(this.getForeignKey((ClassMapping)rel.getMetaData()), rel);
        } else if (this._fk != null) {
            row.whereForeignKey(this._fk, null);
        } else {
            for (int i = 0; i < this._cols.length; ++i) {
                row.whereNull(this._cols[i]);
            }
        }
    }

    @Override
    public ClassMapping[] getIndependentTypeMappings() {
        ClassMapping rel = this.getTypeMapping();
        if (rel == null) {
            return ClassMapping.EMPTY_MAPPINGS;
        }
        if (this._poly != 0) {
            if (!rel.isMapped()) {
                return ClassMapping.EMPTY_MAPPINGS;
            }
            if (this._typeArr == null) {
                this._typeArr = new ClassMapping[]{rel};
            }
            return this._typeArr;
        }
        return rel.getIndependentAssignableMappings();
    }

    @Override
    public int getSelectSubclasses() {
        ClassMapping rel = this.getTypeMapping();
        if (rel == null || !rel.isMapped()) {
            return -1;
        }
        switch (this._poly) {
            case 1: {
                return this._criteria ? 2 : 4;
            }
            case 0: {
                ClassMapping[] assign = rel.getIndependentAssignableMappings();
                if (assign.length != 1 || assign[0] != rel) {
                    return -1;
                }
            }
            case 2: {
                return this._criteria ? 1 : 3;
            }
        }
        throw new InternalException();
    }

    @Override
    public Unique getValueUnique() {
        return this._unq;
    }

    @Override
    public void setValueUnique(Unique unq) {
        this._unq = unq;
    }

    @Override
    public Index getValueIndex() {
        return this._idx;
    }

    @Override
    public void setValueIndex(Index idx) {
        this._idx = idx;
    }

    @Override
    public boolean getUseClassCriteria() {
        if (this._fk == null && this.getValueMappedBy() != null) {
            return this.getValueMappedByMapping().getUseClassCriteria();
        }
        return this._criteria;
    }

    @Override
    public void setUseClassCriteria(boolean criteria) {
        this._criteria = criteria;
    }

    @Override
    public int getPolymorphic() {
        return this._poly;
    }

    @Override
    public void setPolymorphic(int poly) {
        this._poly = poly;
    }

    @Override
    public void refSchemaComponents() {
        ClassMapping embed;
        for (int i = 0; i < this._cols.length; ++i) {
            this._cols[i].ref();
        }
        if (this._fk != null) {
            this._fk.ref();
            this._fk.refColumns();
        }
        if ((embed = this.getEmbeddedMapping()) != null) {
            embed.refSchemaComponents();
        }
    }

    @Override
    @Deprecated
    public void mapConstraints(String name, boolean adapt) {
        this.mapConstraints(DBIdentifier.newConstraint(name), adapt);
    }

    @Override
    public void mapConstraints(DBIdentifier name, boolean adapt) {
        this._unq = this._info.getUnique((ValueMapping)this, name, adapt);
        this._idx = this._info.getIndex((ValueMapping)this, name, adapt);
    }

    @Override
    public void clearMapping() {
        this._handler = null;
        this._cols = Schemas.EMPTY_COLUMNS;
        this._unq = null;
        this._idx = null;
        this._fk = null;
        this._join = 0;
        this._info.clear();
        this.setResolve(10, false);
    }

    @Override
    public void syncMappingInfo() {
        if (this.getValueMappedBy() != null) {
            this._info.clear();
        } else {
            this._info.syncWith(this);
            ClassMapping embed = this.getEmbeddedMapping();
            if (embed != null) {
                embed.syncMappingInfo();
            }
        }
    }

    @Override
    public void copy(ValueMetaData vmd) {
        super.copy(vmd);
        this.copyMappingInfo((ValueMapping)vmd);
    }

    @Override
    public void copyMappingInfo(ValueMapping vm) {
        FieldMapping[] fms;
        FieldMapping[] tmplates;
        this.setValueMappedBy(vm.getValueMappedBy());
        this.setPolymorphic(vm.getPolymorphic());
        this._info.copy(vm.getValueInfo());
        ClassMapping embed = vm.getEmbeddedMapping();
        if (embed != null && this.getEmbeddedMapping() != null && (tmplates = embed.getFieldMappings()).length == (fms = this.getEmbeddedMapping().getFieldMappings()).length) {
            for (int i = 0; i < fms.length; ++i) {
                fms[i].copyMappingInfo(tmplates[i]);
            }
        }
    }

    @Override
    public boolean resolve(int mode) {
        int cur = this.getResolve();
        if (super.resolve(mode)) {
            return true;
        }
        ClassMapping embed = this.getEmbeddedMapping();
        if (embed != null) {
            embed.resolve(mode);
        }
        if ((mode & 2) != 0 && (cur & 2) == 0) {
            this.resolveMapping();
        }
        if ((mode & 8) != 0 && (cur & 8) == 0) {
            this.initializeMapping();
        }
        return false;
    }

    private void resolveMapping() {
        int insertFlag;
        Column[] cols;
        if (this._fk != null) {
            cols = this._fk.getColumns();
            insertFlag = 32;
        } else {
            cols = this.getColumns();
            insertFlag = 8;
        }
        ColumnIO io = this.getColumnIO();
        for (int i = 0; i < cols.length; ++i) {
            if (io.isInsertable(i, false)) {
                cols[i].setFlag(insertFlag, true);
            }
            if (!io.isUpdatable(i, false)) continue;
            cols[i].setFlag(insertFlag, true);
        }
    }

    private void initializeMapping() {
        if (this._fk == null) {
            return;
        }
        Column[] cols = this._fk.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getFlag(8)) {
                this.newIO().setNullInsertable(i, false);
            }
            if (!cols[i].getFlag(16)) continue;
            this.newIO().setNullUpdatable(i, false);
        }
        int len = cols.length;
        cols = this._fk.getConstantColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getFlag(8) || cols[i].getFlag(32)) {
                this.newIO().setInsertable(len + i, false);
            }
            if (!cols[i].getFlag(16) && !cols[i].getFlag(64)) continue;
            this.newIO().setUpdatable(len + i, false);
        }
    }

    private ColumnIO newIO() {
        if (this._io == null) {
            this._io = new ColumnIO();
        }
        return this._io;
    }
}

