/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.osgi;

import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.support.AbstractDelegatedExecutionApplicationContext;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;

public abstract class AbstractBundleTracker
implements BeanFactoryAware,
BundleListener,
BundleContextAware,
InitializingBean,
DisposableBean {
    private BundleContext context;
    private String configuredClass;
    private volatile OsgiServiceFactoryBean osgiFactoryBean;
    private BeanFactory factory;
    private final Logger logger = LoggerFactory.getLogger(AbstractBundleTracker.class);

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle b = event.getBundle();
        if (b.equals(this.context.getBundle())) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                Enumeration entrs = b.findEntries("/", "*.class", true);
                if (entrs == null) break;
                while (entrs.hasMoreElements()) {
                    URL e = (URL)entrs.nextElement();
                    String file = e.getFile();
                    String className = file.replaceAll("/", ".").replaceAll(".class", "").replaceFirst(".", "");
                    if (!className.equals(this.configuredClass)) continue;
                    try {
                        BeanFactory bFactory = this.getBeanFactory(b.getBundleContext());
                        Class<?> clazz = this.getServiceClass();
                        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)bFactory;
                        AbstractBeanDefinition def = BeanDefinitionBuilder.genericBeanDefinition((String)className).getBeanDefinition();
                        registry.registerBeanDefinition(this.getComponentName(), (BeanDefinition)def);
                        this.osgiFactoryBean = new OsgiServiceFactoryBean();
                        this.osgiFactoryBean.setTargetBeanName(this.getComponentName());
                        this.osgiFactoryBean.setBeanFactory(bFactory);
                        this.osgiFactoryBean.setBundleContext(b.getBundleContext());
                        this.osgiFactoryBean.setInterfaces(new Class[]{clazz});
                        this.osgiFactoryBean.afterPropertiesSet();
                        this.logger.debug("Registered {} in the OSGI-Registry with interface {}", (Object)this.configuredClass, (Object)clazz.getName());
                    }
                    catch (Exception e1) {
                        this.logger.error("Unable to register {} in the OSGI-Registry", (Object)this.configuredClass, (Object)e1);
                    }
                }
                break;
            }
            case 4: {
                if (this.osgiFactoryBean == null) break;
                this.osgiFactoryBean.destroy();
                this.osgiFactoryBean = null;
                this.logger.debug("Unregistered {} in the OSGI-Registry with interface {}", (Object)this.configuredClass, (Object)this.getServiceClass().getName());
                break;
            }
        }
    }

    private BeanFactory getBeanFactory(BundleContext bundleContext) throws Exception {
        String filter = "(org.springframework.osgi.bean.name=" + bundleContext.getBundle().getSymbolicName() + ")";
        ServiceReference[] applicationContextRefs = bundleContext.getServiceReferences(ApplicationContext.class.getName(), filter);
        if (applicationContextRefs == null || applicationContextRefs.length != 1) {
            AbstractDelegatedExecutionApplicationContext context = new AbstractDelegatedExecutionApplicationContext(){};
            context.setBundleContext(bundleContext);
            context.setPublishContextAsService(true);
            context.refresh();
            return context.getBeanFactory();
        }
        return ((ApplicationContext)bundleContext.getService(applicationContextRefs[0])).getAutowireCapableBeanFactory();
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurationProvider confProvider = (ConfigurationProvider)this.factory.getBean(ConfigurationProvider.class);
        HierarchicalConfiguration config = confProvider.getConfiguration(this.getComponentName());
        this.configuredClass = config.getString("[@class]");
        if (this.context != null) {
            this.context.addBundleListener((BundleListener)this);
        }
    }

    public void destroy() throws Exception {
        if (this.context != null) {
            this.context.removeBundleListener((BundleListener)this);
        }
    }

    protected abstract String getComponentName();

    protected abstract Class<?> getServiceClass();
}

