/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class UidlCmdHandler
implements CommandHandler<POP3Session>,
CapaCapability {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"UIDL");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"UIDL");

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        String parameters = request.getArgument();
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getAttachment("UID_LIST", ProtocolSession.State.Transaction);
            List deletedUidList = (List)session.getAttachment("DELETED_UID_LIST", ProtocolSession.State.Transaction);
            try {
                String identifier = session.getUserMailbox().getIdentifier();
                if (parameters == null) {
                    response = new POP3Response("+OK", "unique-id listing follows");
                    for (int i = 0; i < uidList.size(); ++i) {
                        MessageMetaData metadata = (MessageMetaData)uidList.get(i);
                        if (deletedUidList.contains(metadata.getUid())) continue;
                        StringBuilder responseBuffer = new StringBuilder().append(i + 1).append(" ").append(metadata.getUid(identifier));
                        response.appendLine(responseBuffer.toString());
                    }
                    response.appendLine(".");
                }
                int num = 0;
                try {
                    num = Integer.parseInt(parameters);
                    MessageMetaData metadata = MessageMetaDataUtils.getMetaData(session, num);
                    if (metadata == null) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        return new POP3Response("-ERR", responseBuffer.toString());
                    }
                    if (!deletedUidList.contains(metadata.getUid())) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(metadata.getUid(identifier));
                        response = new POP3Response("+OK", responseBuffer.toString());
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (IndexOutOfBoundsException npe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NumberFormatException nfe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            }
            catch (IOException e) {
                return POP3Response.ERR;
            }
        } else {
            return POP3Response.ERR;
        }
        return response;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.getHandlerState() == 2) {
            return CAPS;
        }
        return Collections.EMPTY_SET;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

