/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsetCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RSET");
    private static final Logger LOGGER = LoggerFactory.getLogger(RsetCmdHandler.class);

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        if (session.getHandlerState() == 2) {
            this.stat(session);
            return POP3Response.OK;
        }
        return POP3Response.ERR;
    }

    protected void stat(POP3Session session) {
        try {
            List<MessageMetaData> messages = session.getUserMailbox().getMessages();
            session.setAttachment("UID_LIST", messages, ProtocolSession.State.Transaction);
            session.setAttachment("DELETED_UID_LIST", new ArrayList(), ProtocolSession.State.Transaction);
        }
        catch (IOException e) {
            LOGGER.error("Unable to STAT mail box ", (Throwable)e);
        }
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

