/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.Collection;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventDeadLetters;
import org.apache.james.mailbox.events.Group;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryEventDeadLetters
implements EventDeadLetters {
    private final Table<Group, EventDeadLetters.InsertionId, Event> deadLetters = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> store(Group registeredGroup, Event failDeliveredEvent, EventDeadLetters.InsertionId insertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredEvent != null ? 1 : 0) != 0, (Object)"failDeliveredEvent cannot be null");
        Preconditions.checkArgument((insertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        Table<Group, EventDeadLetters.InsertionId, Event> table = this.deadLetters;
        synchronized (table) {
            this.deadLetters.put((Object)registeredGroup, (Object)insertionId, (Object)failDeliveredEvent);
            return Mono.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> remove(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        Table<Group, EventDeadLetters.InsertionId, Event> table = this.deadLetters;
        synchronized (table) {
            this.deadLetters.remove((Object)registeredGroup, (Object)failDeliveredInsertionId);
            return Mono.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Event> failedEvent(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        Table<Group, EventDeadLetters.InsertionId, Event> table = this.deadLetters;
        synchronized (table) {
            return Mono.justOrEmpty((Object)((Event)this.deadLetters.get((Object)registeredGroup, (Object)failDeliveredInsertionId)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flux<EventDeadLetters.InsertionId> failedIds(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Table<Group, EventDeadLetters.InsertionId, Event> table = this.deadLetters;
        synchronized (table) {
            return Flux.fromIterable((Iterable)ImmutableList.copyOf(this.deadLetters.row((Object)registeredGroup).keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flux<Group> groupsWithFailedEvents() {
        Table<Group, EventDeadLetters.InsertionId, Event> table = this.deadLetters;
        synchronized (table) {
            return Flux.fromIterable((Iterable)ImmutableList.copyOf((Collection)this.deadLetters.rowKeySet()));
        }
    }
}

