/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.EventDeadLetters;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.GroupAlreadyRegistered;
import org.apache.james.mailbox.events.GroupRegistrationNotFound;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.MemoryEventDeadLetters;
import org.apache.james.mailbox.events.Registration;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.events.RetryBackoffConfiguration;
import org.apache.james.mailbox.events.delivery.EventDelivery;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InVMEventBus
implements EventBus {
    private final Multimap<RegistrationKey, MailboxListener> registrations;
    private final ConcurrentHashMap<Group, MailboxListener> groups;
    private final EventDelivery eventDelivery;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventDeadLetters eventDeadLetters;

    @Inject
    public InVMEventBus(EventDelivery eventDelivery, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters) {
        this.eventDelivery = eventDelivery;
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.registrations = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.groups = new ConcurrentHashMap();
    }

    @VisibleForTesting
    public InVMEventBus(EventDelivery eventDelivery) {
        this(eventDelivery, RetryBackoffConfiguration.DEFAULT, new MemoryEventDeadLetters());
    }

    public Registration register(MailboxListener listener, RegistrationKey key) {
        this.registrations.put((Object)key, (Object)listener);
        return () -> this.registrations.remove((Object)key, (Object)listener);
    }

    public Registration register(MailboxListener listener, Group group) {
        MailboxListener previous = this.groups.putIfAbsent(group, listener);
        if (previous == null) {
            return () -> this.groups.remove(group, listener);
        }
        throw new GroupAlreadyRegistered(group);
    }

    public Mono<Void> dispatch(Event event, Set<RegistrationKey> keys) {
        if (!event.isNoop()) {
            return Flux.merge((Publisher[])new Publisher[]{this.groupDeliveries(event), this.keyDeliveries(event, keys)}).reduceWith(EventDelivery.ExecutionStages::empty, EventDelivery.ExecutionStages::combine).flatMap(EventDelivery.ExecutionStages::synchronousListenerFuture).then().onErrorResume(throwable -> Mono.empty());
        }
        return Mono.empty();
    }

    public Mono<Void> reDeliver(Group group, Event event) {
        if (!event.isNoop()) {
            return Mono.fromCallable(() -> this.groupDelivery(event, this.retrieveListenerFromGroup(group), group)).flatMap(EventDelivery.ExecutionStages::synchronousListenerFuture).then();
        }
        return Mono.empty();
    }

    private MailboxListener retrieveListenerFromGroup(Group group) {
        return Optional.ofNullable(this.groups.get(group)).orElseThrow(() -> new GroupRegistrationNotFound(group));
    }

    private Flux<EventDelivery.ExecutionStages> keyDeliveries(Event event, Set<RegistrationKey> keys) {
        return Flux.fromIterable(this.registeredListenersByKeys(keys)).map(listener -> this.eventDelivery.deliver((MailboxListener)listener, event, EventDelivery.DeliveryOption.none()));
    }

    private Flux<EventDelivery.ExecutionStages> groupDeliveries(Event event) {
        return Flux.fromIterable(this.groups.entrySet()).map(entry -> this.groupDelivery(event, (MailboxListener)entry.getValue(), (Group)entry.getKey()));
    }

    private EventDelivery.ExecutionStages groupDelivery(Event event, MailboxListener mailboxListener, Group group) {
        return this.eventDelivery.deliver(mailboxListener, event, EventDelivery.DeliveryOption.of(EventDelivery.Retryer.BackoffRetryer.of(this.retryBackoff, mailboxListener), EventDelivery.PermanentFailureHandler.StoreToDeadLetters.of(group, this.eventDeadLetters)));
    }

    public Set<Group> registeredGroups() {
        return this.groups.keySet();
    }

    private Set<MailboxListener> registeredListenersByKeys(Set<RegistrationKey> keys) {
        return (Set)keys.stream().flatMap(registrationKey -> this.registrations.get(registrationKey).stream()).collect(Guavate.toImmutableSet());
    }
}

