/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration2.HierarchicalConfiguration;

public class ReadOnlyLDAPGroupRestriction {
    private String memberAttribute;
    private final List<String> groupDNs = new ArrayList<String>();

    public ReadOnlyLDAPGroupRestriction(HierarchicalConfiguration configuration) {
        if (configuration != null) {
            this.memberAttribute = configuration.getString("[@memberAttribute]");
            if (configuration.getKeys("group").hasNext()) {
                Collections.addAll(this.groupDNs, configuration.getStringArray("group"));
            }
        }
    }

    protected boolean isActivated() {
        return !this.groupDNs.isEmpty();
    }

    public String toString() {
        return "Activated=" + this.isActivated() + "; Groups=" + this.groupDNs;
    }

    protected Map<String, Collection<String>> getGroupMembershipLists(LdapContext ldapContext) throws NamingException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String groupDN : this.groupDNs) {
            result.put(groupDN, this.extractMembers(ldapContext.getAttributes(groupDN)));
        }
        return result;
    }

    private Collection<String> extractMembers(Attributes groupAttributes) throws NamingException {
        ArrayList<String> result = new ArrayList<String>();
        Attribute members = groupAttributes.get(this.memberAttribute);
        NamingEnumeration<?> memberDNs = members.getAll();
        while (memberDNs.hasMore()) {
            result.add(memberDNs.next().toString());
        }
        return result;
    }
}

