/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.dropwizard.DropWizardMetric;
import org.apache.james.metrics.dropwizard.DropWizardTimeMetric;

public class DropWizardMetricFactory
implements MetricFactory {
    private final MetricRegistry metricRegistry;
    private final JmxReporter jmxReporter;

    @Inject
    public DropWizardMetricFactory(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
    }

    public Metric generate(String name) {
        return new DropWizardMetric(this.metricRegistry.counter(name));
    }

    public TimeMetric timer(String name) {
        return new DropWizardTimeMetric(name, this.metricRegistry.timer(name).time());
    }

    @PostConstruct
    public void start() {
        this.jmxReporter.start();
    }

    @PreDestroy
    public void stop() {
        this.jmxReporter.stop();
    }
}

