/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;

public class WelcomeMessageHandler
implements ConnectHandler<SMTPSession> {
    private static final String SERVICE_TYPE = "SMTP";

    public Response onConnect(SMTPSession session) {
        String smtpGreeting = session.getConfiguration().getGreeting();
        SMTPResponse welcomeResponse = smtpGreeting == null ? new SMTPResponse("220", new StringBuilder(256).append(session.getConfiguration().getHelloName()).append(" ").append(this.getServiceType(session)).append(" Server (").append(session.getConfiguration().getSoftwareName()).append(") ready")) : new SMTPResponse("220", smtpGreeting);
        return welcomeResponse;
    }

    protected String getServiceType(SMTPSession session) {
        return SERVICE_TYPE;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

