/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.james.protocols.smtp.CommandInjectionDetectedException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LineBasedFrameDecoder;

public class AllButStartTlsLineBasedChannelHandler
extends LineBasedFrameDecoder {
    private static final String STARTTLS = "starttls";
    private static final Boolean FAIL_FAST = true;
    private final ChannelPipeline pipeline;

    public AllButStartTlsLineBasedChannelHandler(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter) {
        super(maxFrameLength, stripDelimiter, FAIL_FAST == false);
        this.pipeline = pipeline;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        String trimedLowerCasedInput;
        SMTPSession session = (SMTPSession)this.pipeline.getContext("coreHandler").getAttachment();
        if ((session == null || session.needsCommandInjectionDetection()) && this.hasCommandInjection(trimedLowerCasedInput = this.readAll(buffer).trim().toLowerCase(Locale.US))) {
            throw new CommandInjectionDetectedException();
        }
        return super.decode(ctx, channel, buffer);
    }

    private String readAll(ChannelBuffer buffer) {
        return buffer.toString(StandardCharsets.US_ASCII);
    }

    private boolean hasCommandInjection(String trimedLowerCasedInput) {
        List parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().splitToList((CharSequence)trimedLowerCasedInput);
        return this.hasInvalidStartTlsPart(parts) || this.multiPartsAndOneStartTls(parts);
    }

    private boolean multiPartsAndOneStartTls(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(STARTTLS)) && parts.size() > 1;
    }

    private boolean hasInvalidStartTlsPart(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(STARTTLS) && !line.endsWith(STARTTLS));
    }
}

