/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;

public class InMemoryCurrentQuotaManager
implements StoreCurrentQuotaManager {
    private final LoadingCache<QuotaRoot, Entry> quotaCache;

    @Inject
    public InMemoryCurrentQuotaManager(final CurrentQuotaCalculator quotaCalculator, final SessionProvider sessionProvider) {
        this.quotaCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QuotaRoot, Entry>(){

            public Entry load(QuotaRoot quotaRoot) throws Exception {
                return new Entry(quotaCalculator.recalculateCurrentQuotas(quotaRoot, sessionProvider.createSystemSession(quotaRoot.getValue())));
            }
        });
    }

    public void increase(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        this.checkArguments(count, size);
        this.doIncrease(quotaRoot, count, size);
    }

    public void decrease(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        this.checkArguments(count, size);
        this.doIncrease(quotaRoot, -count, -size);
    }

    public QuotaCount getCurrentMessageCount(QuotaRoot quotaRoot) throws MailboxException {
        try {
            return QuotaCount.count((long)((Entry)this.quotaCache.get((Object)quotaRoot)).getCount().get());
        }
        catch (ExecutionException e) {
            throw new MailboxException("Exception caught", (Throwable)e);
        }
    }

    public QuotaSize getCurrentStorage(QuotaRoot quotaRoot) throws MailboxException {
        try {
            return QuotaSize.size((long)((Entry)this.quotaCache.get((Object)quotaRoot)).getSize().get());
        }
        catch (ExecutionException e) {
            throw new MailboxException("Exception caught", (Throwable)e);
        }
    }

    private void doIncrease(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        try {
            Entry entry = (Entry)this.quotaCache.get((Object)quotaRoot);
            entry.getCount().addAndGet(count);
            entry.getSize().addAndGet(size);
        }
        catch (ExecutionException e) {
            throw new MailboxException("Exception caught", (Throwable)e);
        }
    }

    private void checkArguments(long count, long size) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"Count should be positive");
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"Size should be positive");
    }

    class Entry {
        private final AtomicLong count;
        private final AtomicLong size;

        public Entry(CurrentQuotaCalculator.CurrentQuotas currentQuotas) {
            this.count = new AtomicLong(currentQuotas.getCount());
            this.size = new AtomicLong(currentQuotas.getSize());
        }

        public AtomicLong getCount() {
            return this.count;
        }

        public AtomicLong getSize() {
            return this.size;
        }
    }
}

