/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;

public class InMemoryUidProvider
implements UidProvider {
    private final ConcurrentMap<InMemoryId, AtomicLong> map = new ConcurrentHashMap<InMemoryId, AtomicLong>();

    public MessageUid nextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        return this.nextUid(session, mailbox.getMailboxId());
    }

    public MessageUid nextUid(MailboxSession session, MailboxId mailboxId) {
        InMemoryId memoryId = (InMemoryId)mailboxId;
        AtomicLong uid = this.getLast(memoryId);
        if (uid != null) {
            return MessageUid.of((long)uid.incrementAndGet());
        }
        AtomicLong initialUid = new AtomicLong(MessageUid.MIN_VALUE.asLong());
        AtomicLong previousUid = this.map.putIfAbsent(memoryId, initialUid);
        if (previousUid != null) {
            return MessageUid.of((long)previousUid.incrementAndGet());
        }
        return MessageUid.MIN_VALUE;
    }

    public Optional<MessageUid> lastUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        AtomicLong last = this.getLast((InMemoryId)mailbox.getMailboxId());
        if (last == null) {
            return Optional.empty();
        }
        return Optional.of(MessageUid.of((long)last.get()));
    }

    private AtomicLong getLast(InMemoryId id) {
        return (AtomicLong)this.map.get(id);
    }
}

