/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;

public class InMemoryModSeqProvider
implements ModSeqProvider {
    private final ConcurrentMap<InMemoryId, AtomicLong> map = new ConcurrentHashMap<InMemoryId, AtomicLong>();

    public long nextModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        return this.nextModSeq((InMemoryId)mailbox.getMailboxId());
    }

    public long nextModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        return this.nextModSeq((InMemoryId)mailboxId);
    }

    public long highestModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        return this.getHighest((InMemoryId)mailbox.getMailboxId()).get();
    }

    public long highestModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        return this.getHighest((InMemoryId)mailboxId).get();
    }

    private AtomicLong getHighest(InMemoryId id) {
        AtomicLong u;
        AtomicLong uid = (AtomicLong)this.map.get(id);
        if (uid == null && (u = this.map.putIfAbsent(id, uid = new AtomicLong(0L))) != null) {
            uid = u;
        }
        return uid;
    }

    private long nextModSeq(InMemoryId mailboxId) {
        return this.getHighest(mailboxId).incrementAndGet();
    }
}

