/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageMapper;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class InMemoryMessageIdMapper
implements MessageIdMapper {
    private final MailboxMapper mailboxMapper;
    private final InMemoryMessageMapper messageMapper;

    public InMemoryMessageIdMapper(MailboxMapper mailboxMapper, InMemoryMessageMapper messageMapper) {
        this.mailboxMapper = mailboxMapper;
        this.messageMapper = messageMapper;
    }

    public List<MailboxMessage> find(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        try {
            return (List)this.mailboxMapper.list().stream().flatMap(Throwing.function(mailbox -> ImmutableList.copyOf(this.messageMapper.findInMailbox((Mailbox)mailbox, MessageRange.all(), fetchType, -1)).stream())).filter(message -> messageIds.contains(message.getMessageId())).collect(Guavate.toImmutableList());
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    public List<MailboxId> findMailboxes(MessageId messageId) {
        return (List)this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).stream().map(MailboxMessage::getMailboxId).collect(Guavate.toImmutableList());
    }

    public void save(MailboxMessage mailboxMessage) throws MailboxException {
        Mailbox mailbox = this.mailboxMapper.findMailboxById(mailboxMessage.getMailboxId());
        this.messageMapper.save(mailbox, mailboxMessage);
    }

    public void copyInMailbox(MailboxMessage mailboxMessage) throws MailboxException {
        boolean isAlreadyInMailbox = this.findMailboxes(mailboxMessage.getMessageId()).contains(mailboxMessage.getMailboxId());
        if (!isAlreadyInMailbox) {
            this.save(mailboxMessage);
        }
    }

    public void delete(MessageId messageId) {
        this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).forEach(Throwing.consumer(message -> this.messageMapper.delete(this.mailboxMapper.findMailboxById(message.getMailboxId()), (MailboxMessage)message)));
    }

    public void delete(MessageId messageId, Collection<MailboxId> mailboxIds) {
        this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).stream().filter(message -> mailboxIds.contains(message.getMailboxId())).forEach((Consumer<MailboxMessage>)Throwing.consumer(message -> this.messageMapper.delete(this.mailboxMapper.findMailboxById(message.getMailboxId()), (MailboxMessage)message)));
    }

    public Map<MailboxId, UpdatedFlags> setFlags(MessageId messageId, List<MailboxId> mailboxIds, Flags newState, MessageManager.FlagsUpdateMode updateMode) throws MailboxException {
        return (Map)this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).stream().filter(message -> mailboxIds.contains(message.getMailboxId())).map(this.updateMessage(newState, updateMode)).collect(Guavate.entriesToMap());
    }

    private Function<MailboxMessage, Pair<MailboxId, UpdatedFlags>> updateMessage(Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        return Throwing.function(message -> {
            FlagsUpdateCalculator flagsUpdateCalculator = new FlagsUpdateCalculator(newState, updateMode);
            if (flagsUpdateCalculator.buildNewFlags(message.createFlags()).equals((Object)message.createFlags())) {
                UpdatedFlags updatedFlags = UpdatedFlags.builder().modSeq(message.getModSeq()).uid(message.getUid()).oldFlags(message.createFlags()).newFlags(newState).build();
                return Pair.of((Object)message.getMailboxId(), (Object)updatedFlags);
            }
            return Pair.of((Object)message.getMailboxId(), (Object)((UpdatedFlags)this.messageMapper.updateFlags(this.mailboxMapper.findMailboxById(message.getMailboxId()), flagsUpdateCalculator, message.getUid().toRange()).next()));
        });
    }
}

