/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.transaction.Mapper;

public class InMemoryMailboxMapper
implements MailboxMapper {
    private static final int INITIAL_SIZE = 128;
    private final ConcurrentHashMap<MailboxPath, Mailbox> mailboxesByPath;
    private final AtomicLong mailboxIdGenerator = new AtomicLong();

    public InMemoryMailboxMapper() {
        this.mailboxesByPath = new ConcurrentHashMap(128);
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        this.mailboxesByPath.remove(mailbox.generateAssociatedPath());
    }

    public void deleteAll() throws MailboxException {
        this.mailboxesByPath.clear();
    }

    public synchronized Mailbox findMailboxByPath(MailboxPath path) throws MailboxException {
        Mailbox result = this.mailboxesByPath.get(path);
        if (result == null) {
            throw new MailboxNotFoundException(path);
        }
        return new Mailbox(result);
    }

    public synchronized Mailbox findMailboxById(MailboxId id) throws MailboxException {
        InMemoryId mailboxId = (InMemoryId)id;
        for (Mailbox mailbox : this.mailboxesByPath.values()) {
            if (!mailbox.getMailboxId().equals(mailboxId)) continue;
            return new Mailbox(mailbox);
        }
        throw new MailboxNotFoundException((MailboxId)mailboxId);
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        String regex = path.getName().replace("%", ".*");
        return (List)this.mailboxesByPath.values().stream().filter(mailbox -> this.mailboxMatchesRegex((Mailbox)mailbox, path, regex)).map(Mailbox::new).collect(Guavate.toImmutableList());
    }

    private boolean mailboxMatchesRegex(Mailbox mailbox, MailboxPath path, String regex) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)path.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)path.getUser()) && mailbox.getName().matches(regex);
    }

    public MailboxId save(Mailbox mailbox) throws MailboxException {
        InMemoryId id = (InMemoryId)mailbox.getMailboxId();
        if (id == null) {
            id = InMemoryId.of(this.mailboxIdGenerator.incrementAndGet());
            mailbox.setMailboxId((MailboxId)id);
        } else {
            try {
                Mailbox mailboxWithPreviousName = this.findMailboxById(id);
                this.mailboxesByPath.remove(mailboxWithPreviousName.generateAssociatedPath());
            }
            catch (MailboxNotFoundException mailboxWithPreviousName) {
                // empty catch block
            }
        }
        Mailbox previousMailbox = this.mailboxesByPath.putIfAbsent(mailbox.generateAssociatedPath(), mailbox);
        if (previousMailbox != null) {
            throw new MailboxExistsException(mailbox.getName());
        }
        return mailbox.getMailboxId();
    }

    public void endRequest() {
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException {
        String mailboxName = mailbox.getName() + delimiter;
        return this.mailboxesByPath.values().stream().anyMatch(box -> this.belongsToSameUser(mailbox, (Mailbox)box) && box.getName().startsWith(mailboxName));
    }

    private boolean belongsToSameUser(Mailbox mailbox, Mailbox otherMailbox) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)otherMailbox.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)otherMailbox.getUser());
    }

    public List<Mailbox> list() throws MailboxException {
        return new ArrayList<Mailbox>(this.mailboxesByPath.values());
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }

    public ACLDiff updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) throws MailboxException {
        MailboxACL oldACL = mailbox.getACL();
        MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
        this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(newACL);
        return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
    }

    public ACLDiff setACL(Mailbox mailbox, MailboxACL mailboxACL) throws MailboxException {
        MailboxACL oldMailboxAcl = mailbox.getACL();
        this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(mailboxACL);
        return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
    }

    public List<Mailbox> findNonPersonalMailboxes(String userName, MailboxACL.Right right) throws MailboxException {
        return (List)this.mailboxesByPath.values().stream().filter(mailbox -> this.hasRightOn((Mailbox)mailbox, userName, right)).collect(Guavate.toImmutableList());
    }

    private Boolean hasRightOn(Mailbox mailbox, String userName, MailboxACL.Right right) {
        return Optional.ofNullable((MailboxACL.Rfc4314Rights)mailbox.getACL().ofPositiveNameType(MailboxACL.NameType.user).get(MailboxACL.EntryKey.createUserEntryKey((String)userName))).map(rights -> rights.contains(right)).orElse(false);
    }
}

