/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class JsoupTextExtractor
implements TextExtractor {
    private static final String TITLE_HTML_TAG = "title";

    public ParsedContent extractContent(InputStream inputStream, String contentType) throws Exception {
        HashMap emptyMetadata = Maps.newHashMap();
        if (contentType != null) {
            if (contentType.equals("text/plain")) {
                return new ParsedContent(Optional.ofNullable(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)), (Map)emptyMetadata);
            }
            if (contentType.equals("text/html")) {
                Document doc = Jsoup.parse((String)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                doc.select(TITLE_HTML_TAG).remove();
                return new ParsedContent(Optional.ofNullable(doc.text()), (Map)emptyMetadata);
            }
        }
        return new ParsedContent(null, (Map)emptyMetadata);
    }
}

